package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "DamageRateDetailReportRespDto", description = "破损率统计明细对象")
public class DamageRateDetailReportRespDto extends BaseRespDto {

    @ApiModelProperty(name = "monthStr", value = "月份")
    private String monthStr;

    @ApiModelProperty(name = "platformOrderNo", value = "渠道订单号")
    private String platformOrderNo;

    @ApiModelProperty(name = "saleOrderNo", value = "内部销售单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "easOrderNo", value = "eas单号")
    private String easOrderNo;

    @ApiModelProperty(name = "bizDay", value = "业务日期")
    private String bizDay;

    @ApiModelProperty(name = "customerId", value = "承运商id")
    private String customerId;

    @ApiModelProperty(name = "customerName", value = "承运商名称")
    private String customerName;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "skuCode", value = "物料编码")
    private String skuCode;

    @ApiModelProperty(name = "itemName", value = "物料名称")
    private String itemName;

    @ApiModelProperty(name = "unit", value = "计量单位")
    private String unit;

    @ApiModelProperty(name = "itemNum", value = "出库数量")
    private Integer itemNum;

    @ApiModelProperty(name = "price", value = "零售价")
    private BigDecimal price;

    @ApiModelProperty(name = "salePrice", value = "单价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "orderTotalAmount", value = "价税合计")
    private BigDecimal orderTotalAmount;

    @ApiModelProperty(name = "logicalWarehouseName", value = "发货逻辑仓")
    private String logicalWarehouseName;

    @ApiModelProperty(name = "receiveAddress", value = "收货地址")
    private String receiveAddress;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "sellerRemark", value = "索赔单备注")
    private String sellerRemark;


}
