package com.dtyunxi.tcbj.api.dto.response;

import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 渠道仓库存表Eo对象
*
* @author wude
* @since 2022-03-09
*/
@ApiModel(value = "ChannelInventoryRespDto", description = "渠道仓库存表Eo对象")
@Getter
@Setter
public class ChannelInventoryRespDto extends BaseDto {
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "allocate", value = "已分配库存")
    private BigDecimal allocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "activityAllocate", value = "活动分配库存")
    private BigDecimal activityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "transfer", value = "已调拨库存")
    private BigDecimal transfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "completed", value = "已完成库存")
    private BigDecimal completed;
    /**
    *  可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品条码
     */
    @ApiModelProperty(name = "itemBarCode", value = "商品条码")
    private String itemBarCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "relShareInventoryList", value = "渠道仓库存对应边库存信息")
    private List<RelShareInventoryRespDto> relShareInventoryList;
}
