package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@Getter
@Setter
@ApiModel(value = "SkuInventoryBatchRespDto", description = "sku库存统计响应对象")
public class SkuInventoryBatchRespDto {
    @ApiModelProperty(name = "skuCode", value = "货品编码")
    private String skuCode;


    @ApiModelProperty(name = "batchMonth", value = "批次月份")
    private String batchMonth;

    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库名称")
    private String physicsWarehouseName;

    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;


    @ApiModelProperty(name = "replenishmentInventory", value = "补货可用库存")
    private BigDecimal replenishmentInventory;

    @ApiModelProperty(name = "allInventory", value = "全国可用库存")
    private BigDecimal allInventory;

    @ApiModelProperty(name = "detailList", value = "月份批次明细")
    private List<Detail> detailList;

    @Getter
    @Setter
    public static class Detail{
        @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
        private String warehouseCode;

        @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库名称")
        private String warehouseName;

        @ApiModelProperty(name = "batch", value = "批次")
        private String batch;

        @ApiModelProperty(name = "skuCode", value = "货品编码")
        private String skuCode;

        @ApiModelProperty(name = "warehouseQuality", value = "仓库品质")
        private String warehouseQuality;

        @ApiModelProperty(name = "availableInventory", value = "可用库存")
        private BigDecimal availableInventory;

        @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
        private String physicsWarehouseCode;

        @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库名称")
        private String physicsWarehouseName;

        @ApiModelProperty(name = "organizationCode", value = "组织编码")
        private String organizationCode;
        private String organizationName;
    }
}
