package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckEasReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
* 渠道仓库存表服务接口
*
* @author wude
* @since 2022-03-09
*/
@Api(tags = {"库存校验服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/inventoryCheck", url = "${tcbj.center.report.api:}")
public interface IInventoryCheckApi {


    /**
     * 库存校验
     * @param checkReqDto 请求对象
     * @return 结果
     */
    @PostMapping("/check")
    @ApiOperation(value = "库存校验", notes = "库存校验")
    RestResponse<InventoryCheckRespDto> check(@Valid @RequestBody InventoryCheckReqDto checkReqDto);

    @PostMapping("/checkForEas")
    @ApiOperation(value = "库存校验，EAS发起专用", notes = "库存校验，EAS发起专用")
    RestResponse<InventoryCheckRespDto> checkForEas(@Valid @RequestBody InventoryCheckEasReqDto checkReqDto);

    @PostMapping("/checkForShare")
    @ApiOperation(value = "通过逻辑仓校验共享中心库存", notes = "通过逻辑仓校验共享中心库存")
    RestResponse<InventoryCheckRespDto> checkForShare(@Valid @RequestBody InventoryCheckReqDto checkReqDto);

    @PostMapping("/batchCheckForShare")
    @ApiOperation(value = "通过多个逻辑仓校验共享中心库存", notes = "通过多个逻辑仓校验共享中心库存")
    RestResponse<InventoryCheckRespDto> batchCheckForShare(@Valid @RequestBody InventoryCheckReqDto checkReqDto);

}
