package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.response.ApportionDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 仓储费用分摊表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储费用分摊表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IStorageChargeApportionQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeApportion",
    url = "${tcbj.center.report.api:}"
)
public interface IStorageChargeApportionQueryApi {

    /**
    * 根据id查询仓储费用分摊表
    *
    * @param id 仓储费用分摊表id
    * @return   仓储费用分摊表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储费用分摊表", notes = "根据id查询仓储费用分摊表")
    RestResponse<StorageChargeApportionRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓储费用分摊表分页数据
    *
    * @param filter   仓储费用分摊表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储费用分摊表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓储费用分摊表分页数据", notes = "根据filter查询条件查询仓储费用分摊表数据，filter=StorageChargeApportionReqDto")
    RestResponse<PageInfo<StorageChargeApportionRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
