package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOutResultInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 物流信息表服务接口
 *
 * @author 宁毅
 * @since 2022-05-07
 */
@Api(tags = {"物流信息表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        url = "${tcbj.center.report.api:}",
        path = "/v1/logistics/info"
)
public interface ICsLogisticsInfoQueryApi {

    /**
     * 根据id查询物流信息表
     *
     * @param id 物流信息表id
     * @return 物流信息表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流信息表", notes = "根据id查询物流信息表")
    RestResponse<CsLogisticsInfoRespDto> queryById(@PathVariable("id") Long id);


    /**
     * 根据CSP单号批量查询物流信息
     *
     * @param cspNoList CSP单号集合
     * @return 物流信息表数据
     */
    @PostMapping("/queryByCspNos")
    @ApiOperation(value = "根据CSP单号批量查询物流信息", notes = "根据CSP单号批量查询物流信息")
    RestResponse<List<CsLogisticsInfoRespDto>> queryByCspNos(@RequestBody List<String> cspNoList);


    /**
     * 物流信息表分页数据
     *
     * @param reqDto   物流信息表查询条件
     * @return 物流信息表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "物流信息表分页数据", notes = "根据filter查询条件查询物流信息表数据，filter=CsLogisticsInfoReqDto")
    RestResponse<PageInfo<CsLogisticsInfoRespDto>> queryByPage(@RequestBody CsLogisticsInfoReqDto reqDto);

    @GetMapping("/detail")
    @ApiOperation(value = "获取物流信息详情", notes = "获取物流信息详情")
    RestResponse<LogisticsInfoRespDto> queryLogisticsInfoReqDto(@RequestParam(name = "shippingCode") String shippingCode);

    @GetMapping("/queryConsignmentLogisticsInfoReqDto/{consignmentNo}")
    @ApiOperation(value = "根据运单号获取物流信息", notes = "根据运单号获取物流信息")
    RestResponse<ConsignmentOrderLogisticsRespDto> queryConsignmentLogisticsInfoReqDto(@PathVariable("consignmentNo") String consignmentNo);

    @PostMapping("/queryResultDeliveryInformation/{documentNo}")
    @ApiOperation(value = "根据入库结果单号查询配送信息", notes = "根据入库结果单号查询配送信息")
    RestResponse<List<DeliveryInformationRespDto>> queryResultDeliveryInformation(@PathVariable("documentNo") String documentNo);

    @PostMapping("/queryOutDeliveryInformation/{documentNo}")
    @ApiOperation(value = "根据入库通知单单号查询配送信息", notes = "根据入库通知单单号查询配送信息")
    RestResponse<List<DeliveryInformationRespDto>> queryOutDeliveryInformation(@PathVariable("documentNo") String documentNo);

    @PostMapping("/queryTakeDeliveryInformation/{documentNo}")
    @ApiOperation(value = "根据收发货通知单单号查询配送信息", notes = "根据收发货通知单单号查询配送信息")
    RestResponse<List<DeliveryInformationRespDto>> queryTakeDeliveryInformation(@PathVariable("documentNo") String documentNo);

    @PostMapping("/queryTakeDeliveryResultInformation/{documentNo}")
    @ApiOperation(value = "根据收发货结果单单号查询配送信息", notes = "根据收发货结果单单号查询配送信息")
    RestResponse<List<DeliveryInformationRespDto>> queryTakeDeliveryResultInformation(@PathVariable("documentNo") String documentNo);

    @PostMapping("/queryLogisticsOutResultByList")
    @ApiOperation(value = "物流在途和出库结果单信息", notes = "物流在途和出库结果单信息")
    RestResponse<List<LogisticOutResultInfoRespDto>> queryLogisticsOutResultByList(@RequestBody LogisticOutResultInfoReqDto queryDto);
}
