package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 查询销售结果信息（包含销售红单结果）
 */
@Data
public class SaleOrderResultReqDto extends BaseDto {

    @ApiModelProperty(name = "documentNo", value = "eas结果单")
    private String documentNo;

    @ApiModelProperty(name = "saleType", value = "销售类型：SALE（销售单，默认）；SALE_RED（销售红单）")
    private String saleType;

    @ApiModelProperty(name = "createBeginTime", value = "开始时间")
    private String createBeginTime;

    @ApiModelProperty(name = "createEndTime", value = "结束时间")
    private String createEndTime;

    @ApiModelProperty(name = "saleOrderType", value = "销售单单据类型")
    private String saleOrderType;

    @ApiModelProperty(name = "saleOrderSource", value = "销售单来源类型")
    private String saleOrderSource;

    @ApiModelProperty(name = "relevanceNo", value = "关联单号")
    private String relevanceNo;

    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;

    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;

    @ApiModelProperty(name = "mainOrderNo", value = "主单号")
    private String mainOrderNo;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "businessType", value = "业务类型多个")
    private List<String> businessTypes;

    private List<String> baseBusinessTypes;

    private String createStartTime;

    @ApiModelProperty(name = "excludeOrgCode",value = "排除销售组织")
    private List<String> excludeOrgCode;

    @ApiModelProperty(name = "excludeOrderType",value = "排除单据类型")
    private List<String> excludeOrderType;

    @ApiModelProperty(name = "ifExcludeKmh",value = "是否排除开门红标签")
    private Integer ifExcludeKmh;

    @ApiModelProperty(name = "saleOrderNos",value = "销售单号")
    private List<String> saleOrderNos;
}
