package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryCountReDto;
import com.dtyunxi.tcbj.api.dto.request.FinishedInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 成品库存报表服务接口
*
* @author 紫霄
* @since 2022-12-08
*/
@Api(tags = {"成品库存报表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IFinishedInventoryQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/finishedInventory",
    url = "${tcbj.center.report.api:}"
)
public interface IFinishedInventoryQueryApi {

    /**
    * 根据id查询成品库存报表
    *
    * @param id 成品库存报表id
    * @return   成品库存报表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询成品库存报表", notes = "根据id查询成品库存报表")
    RestResponse<FinishedInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 成品库存报表分页数据
    *
    * @param req   成品库存报表查询条件
    * @return 成品库存报表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "成品库存报表分页数据", notes = "根据filter查询条件查询成品库存报表数据，filter=FinishedInventoryReqDto")
    RestResponse<PageInfo<FinishedInventoryRespDto>> queryByPage(@RequestBody FinishedInventoryReqDto req);

    @PostMapping("/queryFinishedInventoryByCount")
    @ApiOperation(value = "成品库存统计", notes = "根据filter查询条件查询成品库存统计数据，filter=LogicInventoryReqDto")
    RestResponse<List<FinishedInventoryCountRespDto>> queryChannelInventoryByCount(@RequestBody FinishedInventoryReqDto req);

}
