package com.dtyunxi.tcbj.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author longde
 */
@Data
@ApiModel(value = "WarehouseThresholdRespDto", description = "仓库发货阈值dto")
public class WarehouseThresholdRespDto {


    @ApiModelProperty(name = "id", value = "仓库id")
    private Long id;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "orderCount", value = "出库总单")
    private  Integer orderCount;

    @ApiModelProperty(name = "logicWarehouseCodeStr", value = "物理仓编码")
    private String logicWarehouseCodeStr;

    public List<String> getLogicWarehouseCodeList() {
        if (StringUtils.isBlank(logicWarehouseCodeStr)){
            return Lists.newArrayList();
        }
        return Arrays.stream(logicWarehouseCodeStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }
}
