package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 逻辑仓库存快照表服务接口
*
* @author mc
* @since 2022-10-13
*/
@Api(tags = {"逻辑仓库存快照表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ILogicInventorySnapApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/inventory/snap",
    url = "${tcbj.center.report.api:}"
)
public interface ILogicInventorySnapApi {

/**
* 新增逻辑仓库存快照表
*
* @param addReqDto 逻辑仓库存快照表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增逻辑仓库存快照表", notes = "新增逻辑仓库存快照表")
RestResponse<Long> addLogicInventorySnap(@RequestBody LogicInventorySnapReqDto addReqDto);

    /**
    * 修改逻辑仓库存快照表
    *
    * @param modifyReqDto 逻辑仓库存快照表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改逻辑仓库存快照表", notes = "修改逻辑仓库存快照表")
    RestResponse<Void> modifyLogicInventorySnap(@RequestBody LogicInventorySnapReqDto modifyReqDto);

    /**
    * 删除逻辑仓库存快照表
    *
    * @param ids        逻辑仓库存快照表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除逻辑仓库存快照表", notes = "删除逻辑仓库存快照表")
    RestResponse<Void> removeLogicInventorySnap(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
     * 导入修改逻辑仓库存快照表
     *
     * @param logicInventorySnapReqDtos 逻辑仓库存快照表请求对象
     * @return 处理结果
     */
    @PostMapping("/importModifyLogicInventorySnap")
    @ApiOperation(value = "导入修改逻辑仓库存快照表", notes = "导入修改逻辑仓库存快照表")
    RestResponse<Void> importModifyLogicInventorySnap(@RequestBody List<LogicInventorySnapReqDto> logicInventorySnapReqDtos);

}
