package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.ResponseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 仓储费用分摊明细表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeApportionDetailRespDto", description = "仓储费用分摊明细表Eo对象")
public class StorageChargeApportionDetailRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  关联分摊主表ID
    */
    @ApiModelProperty(name = "apportionId", value = "关联分摊主表ID")
    private Long apportionId;
    /**
    *  统计数据月份
    */
    @ApiModelProperty(name = "recordMonth", value = "统计数据月份")
    @JSONField(format ="yyyy-MM-dd")
    private Date recordMonth;
    /**
    *  账单统计日期
    */
    @ApiModelProperty(name = "billTime", value = "账单统计日期")
    private Date billTime;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "opLongCode", value = "商品长编码")
    private String opLongCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  分摊起始时间
    */
    @ApiModelProperty(name = "apportionStartTime", value = "分摊起始时间")
    private Date apportionStartTime;
    /**
    *  分摊结束时间
    */
    @ApiModelProperty(name = "apportionEndTime", value = "分摊结束时间")
    private Date apportionEndTime;
    /**
    *  分摊总数
    */
    @ApiModelProperty(name = "apportionAllNum", value = "分摊总数")
    private Integer apportionAllNum;
    /**
    *  分摊数
    */
    @ApiModelProperty(name = "apportionNum", value = "分摊数")
    private Integer apportionNum;
    /**
    *  分摊板数
    */
    @ApiModelProperty(name = "apportionSupport", value = "分摊板数")
    private BigDecimal apportionSupport;
    /**
    *  货权归属组织id
    */
    @ApiModelProperty(name = "belongOrgId", value = "货权归属组织id")
    private Long belongOrgId;
    /**
    *  货权归属组织名称
    */
    @ApiModelProperty(name = "belongOrgName", value = "货权归属组织名称")
    private String belongOrgName;
    /**
    *  分摊逻辑仓编码
    */
    @ApiModelProperty(name = "apportionLogicWarehouseCode", value = "分摊逻辑仓编码")
    private String apportionLogicWarehouseCode;
    /**
    *  分摊逻辑仓名称
    */
    @ApiModelProperty(name = "apportionLogicWarehouseName", value = "分摊逻辑仓名称")
    private String apportionLogicWarehouseName;

    /**
     *  分摊库存组织id
     */
    @ApiModelProperty(name = "apportionOrgId", value = "分摊库存组织id")
    private Long apportionOrgId;
    /**
     *  分摊库存组织名称
     */
    @ApiModelProperty(name = "apportionOrgName", value = "分摊库存组织名称")
    private String apportionOrgName;

    /**
    *  分摊操作人
    */
    @ApiModelProperty(name = "apportionOperator", value = "分摊操作人")
    private String apportionOperator;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setApportionId(Long apportionId){
    this.apportionId = apportionId;
    }
    public Long getApportionId(){
    return this.apportionId;
    }
    public void setRecordMonth(Date recordMonth){
    this.recordMonth = recordMonth;
    }
    public Date getRecordMonth(){
    return this.recordMonth;
    }
    public void setBillTime(Date billTime){
    this.billTime = billTime;
    }
    public Date getBillTime(){
    return this.billTime;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setOpLongCode(String opLongCode){
    this.opLongCode = opLongCode;
    }
    public String getOpLongCode(){
    return this.opLongCode;
    }
    public void setItemName(String itemName){
    this.itemName = itemName;
    }
    public String getItemName(){
    return this.itemName;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setApportionStartTime(Date apportionStartTime){
    this.apportionStartTime = apportionStartTime;
    }
    public Date getApportionStartTime(){
    return this.apportionStartTime;
    }
    public void setApportionEndTime(Date apportionEndTime){
    this.apportionEndTime = apportionEndTime;
    }
    public Date getApportionEndTime(){
    return this.apportionEndTime;
    }
    public void setApportionAllNum(Integer apportionAllNum){
    this.apportionAllNum = apportionAllNum;
    }
    public Integer getApportionAllNum(){
    return this.apportionAllNum;
    }
    public void setApportionNum(Integer apportionNum){
    this.apportionNum = apportionNum;
    }
    public Integer getApportionNum(){
    return this.apportionNum;
    }
    public void setApportionSupport(BigDecimal apportionSupport){
    this.apportionSupport = apportionSupport;
    }
    public BigDecimal getApportionSupport(){
    return this.apportionSupport;
    }
    public void setBelongOrgId(Long belongOrgId){
    this.belongOrgId = belongOrgId;
    }
    public Long getBelongOrgId(){
    return this.belongOrgId;
    }
    public void setBelongOrgName(String belongOrgName){
    this.belongOrgName = belongOrgName;
    }
    public String getBelongOrgName(){
    return this.belongOrgName;
    }
    public void setApportionLogicWarehouseCode(String apportionLogicWarehouseCode){
    this.apportionLogicWarehouseCode = apportionLogicWarehouseCode;
    }
    public String getApportionLogicWarehouseCode(){
    return this.apportionLogicWarehouseCode;
    }
    public void setApportionLogicWarehouseName(String apportionLogicWarehouseName){
    this.apportionLogicWarehouseName = apportionLogicWarehouseName;
    }
    public String getApportionLogicWarehouseName(){
    return this.apportionLogicWarehouseName;
    }
    public void setApportionOperator(String apportionOperator){
    this.apportionOperator = apportionOperator;
    }
    public String getApportionOperator(){
    return this.apportionOperator;
    }
    public Long getApportionOrgId() {
        return apportionOrgId;
    }

    public void setApportionOrgId(Long apportionOrgId) {
        this.apportionOrgId = apportionOrgId;
    }

    public String getApportionOrgName() {
        return apportionOrgName;
    }

    public void setApportionOrgName(String apportionOrgName) {
        this.apportionOrgName = apportionOrgName;
    }
}
