package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

@Getter
@Setter
@ApiModel(value = "InspectionReleaseLogicInventoryRespDto", description = "待检放行返回对象")
public class InspectionReleaseLogicInventoryRespDto extends BaseRespDto {

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    private String inspectionReleaseNo;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 货品规格
     */
    @ApiModelProperty(name = "specification", value = "货品规格")
    private String specification;

    /**
     * 货品批次
     */
    @ApiModelProperty(name = "batch", value = "货品批次")
    private String batch;

    /**
     * 即时库存
     */
    @ApiModelProperty(name = "balance", value = "即时库存")
    private BigDecimal balance;

    /**
     * 预占库存
     */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;

    /**
     * 可用库存
     */
    @ApiModelProperty(name = "available", value = "可用库存")
    private BigDecimal available;

    /**
     * 状态名称
     */
    @ApiModelProperty(name = "statusName", value = "状态名称")
    private String statusName;

    /**
     * 状态编码
     */
    @ApiModelProperty(name = "status", value = "状态编码")
    private Integer status;

    @ApiModelProperty(name = "taskStatus", value = "任务状态")
    private String taskStatus;

    @ApiModelProperty(name = "taskStatusName", value = "任务状态名称")
    private String taskStatusName;

    /**
     * 标签
     */
    @ApiModelProperty(name = "tag", value = "标签")
    private String tag;

    @ApiModelProperty(name = "colourId", value = "标签id")
    private Long colourId;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 待检入库数量
     */
    @ApiModelProperty(name = "inspectionInNum", value = "待检入库数量")
    private BigDecimal inspectionInNum;

    /**
     * 待检在库数量
     */
    @ApiModelProperty(name = "inspectionBalanceNum", value = "待检在库数量")
    private BigDecimal inspectionBalanceNum;

    /**
     * 待检在途数量
     */
    @ApiModelProperty(name = "inspectionIntransitNum", value = "待检在途数量")
    private BigDecimal inspectionIntransitNum;

    /**
     * 待检出库数量
     */
    @ApiModelProperty(name = "inspectionOutNum", value = "待检出库数量")
    private BigDecimal inspectionOutNum;

    /**
     * 计划放行数量
     */
    @ApiModelProperty(name = "planReleaseNum", value = "计划放行数量")
    private BigDecimal planReleaseNum;
    /**
     *  计划目标放行数量
     */
    @ApiModelProperty(name = "planTargetReleaseNum", value = "计划放行数量")
    private BigDecimal planTargetReleaseNum;

    /**
     * 放行数量
     */
    @ApiModelProperty(name = "releaseNum", value = "放行数量")
    private BigDecimal releaseNum;

    /**
     * 在库与计划差异
     */
    @ApiModelProperty(name = "balanceDiffPlanNum", value = "在库与计划差异")
    private BigDecimal balanceDiffPlanNum;

    /**
     * 质检报告
     */
    @ApiModelProperty(name = "reportUrl", value = "质检报告")
    private String reportUrl;
    /**
     * 报告结果
     */
    @ApiModelProperty(name = "reportResult", value = "报告结果")
    private String reportResult;
    /**
     * 报告出示时间
     */
    @ApiModelProperty(name = "reportTime", value = "报告出示时间")
    private Date reportTime;
    /**
     * 预计出报告时间
     */
    @ApiModelProperty(name = "reportPlanTime", value = "预计出报告时间")
    private String reportPlanTime;
    /**
     * 质检受理时间
     */
    @ApiModelProperty(name = "reportAcceptTime", value = "质检受理时间")
    private String reportAcceptTime;
    /**
     * 质检提单时间
     */
    @ApiModelProperty(name = "reportSubmitTime", value = "质检提单时间")
    private String reportSubmitTime;
    /**
     * 初次入库时间
     */
    @ApiModelProperty(name = "firstInStockTime", value = "初次入库时间")
    private String firstInStockTime;
    /**
     * 超2天未提单
     */
    @ApiModelProperty(name = "over2DaysNotSubmit", value = "超2天未提单")
    private Boolean over2DaysNotSubmit;
    /**
     * 超7天未出报告
     */
    @ApiModelProperty(name = "over7DaysNotReport", value = "超7天未出报告")
    private Boolean over7DaysNotReport;
    /**
     * 超3天未放行
     */
    @ApiModelProperty(name = "over3DaysNotRelease", value = "超3天未放行")
    private Boolean over3DaysNotRelease;
    /**
     * 批次倒挂
     */
    @ApiModelProperty(name = "batchUnfair", value = "批次倒挂")
    private Boolean batchUnfair;

    @ApiModelProperty(name = "releaseTime", value = "放行时间")
    private Date releaseTime;

    @ApiModelProperty(name = "releasePerson", value = "放行人")
    private String releasePerson;

    @ApiModelProperty(name = "ingReleaseNum", value = "放行中的数量")
    private BigDecimal ingReleaseNum;

    @ApiModelProperty(name = "endReleaseNum", value = "已放行的数量")
    private BigDecimal endReleaseNum;

    @ApiModelProperty(name = "totalReleaseNum", value = "总放行的数量")
    private BigDecimal totalReleaseNum;

    @ApiModelProperty(name = "planReleaseNumDiffIn", value = "计划与入库差异")
    private BigDecimal planReleaseNumDiffIn;

    @ApiModelProperty(name = "planReleaseNumDiffEndRelease", value = "计划与实际差异")
    private BigDecimal planReleaseNumDiffEndRelease;

    @ApiModelProperty(name = "preemptSumNum", value = "预占数")
    private BigDecimal preemptSumNum = BigDecimal.ZERO;

    @ApiModelProperty(name = "notReleaseSum", value = "无需放行数")
    private BigDecimal notReleaseSum = BigDecimal.ZERO;
}
