package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 出库结果单Eo对象
*
* @author wude
* @since 2022-03-10
*/
@ApiModel(value = "OutResultOrderRespDto", description = "出库结果单Eo对象")
@Data
public class OutResultOrderRespDto extends BaseRespDto {
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  出库结果单号
    */
    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
    *  外部单号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
    *  发货店铺ID
    */
    @ApiModelProperty(name = "shopId", value = "发货店铺ID")
    private Long shopId;
    /**
    *  发货店铺编码
    */
    @ApiModelProperty(name = "shopCode", value = "发货店铺编码")
    private String shopCode;
    /**
    *  发货店铺名称
    */
    @ApiModelProperty(name = "shopName", value = "发货店铺名称")
    private String shopName;
    /**
    *  发货仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "发货仓库ID")
    private Long warehouseId;
    /**
     *  发货逻辑仓库编码
     */
    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货逻辑仓库编码")
    private String deliveryWarehouseCode;
    /**
     *  发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryWarehouseName;
    /**
    *  仓库分类,physics-物理仓,logic-逻辑仓
    */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
    *  出库总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "出库总数量")
    private BigDecimal totalQuantity;
    /**
     *  sku数量
     */
    @ApiModelProperty(name = "totalSku", value = "sku数量")
    private BigDecimal totalSku;
    /**
     * 总重量
     */
    @ApiModelProperty(name = "totalWeight", value = "总重量")
    private BigDecimal totalWeight;

    /**
     * 总体积
     */
    @ApiModelProperty(name = "totalVolume", value = "总体积")
    private BigDecimal totalVolume;

    @ApiModelProperty(name="totalBoxesNum", value = "总箱数")
    private BigDecimal totalBoxesNum = null;

    @ApiModelProperty(name="mixBoxesNum", value = "拼箱数")
    private BigDecimal mixBoxesNum = null;
    /**
    *  物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)
    */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;
    /**
    *  物流公司名称
    */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;
    /**
    *  物流公司运单号（存储母单号）
    */
    @ApiModelProperty(name = "shippingCode", value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 收货逻辑仓库编码
     */
    @ApiModelProperty(name = "receiveWarehouseCode", value = "收货逻辑仓库编码")
    private String receiveWarehouseCode;
    /**
     *  收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货逻辑仓库名称")
    private String receiveWarehouseName;
    /**
     * WMS订单号
     */
    @ApiModelProperty(name="wmsNo", value = "WMS订单号")
    private String wmsNo;
    /**
     * 商品明细信息
     */
    @ApiModelProperty(name = "detailRespDtos", value = "商品明细信息")
    private List<CsOutResultOrderDetailRespDto> detailRespDtos;

    @ApiModelProperty(name="overChargeTime", value = "挂起时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date overChargeTime;
    @ApiModelProperty(name="orderType", value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;
    /**
     *  发货通知单号
     */
    @ApiModelProperty(name = "noticeNo", value = "发货通知单号")
    private String noticeNo;
    /**
     * 业务时间
     */
    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;
    @ApiModelProperty(name="overChargeReason", value = "挂起原因")
    private String overChargeReason;
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     *  过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    @ApiModelProperty(name = "barCode", value = "商品条码")
    private String barCode;

    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    public void setDocumentNo(String documentNo){
    this.documentNo = documentNo;
    }
    public String getDocumentNo(){
    return this.documentNo;
    }
    public void setRelevanceNo(String relevanceNo){
    this.relevanceNo = relevanceNo;
    }
    public String getRelevanceNo(){
    return this.relevanceNo;
    }
    public void setPreOrderNo(String preOrderNo){
    this.preOrderNo = preOrderNo;
    }
    public String getPreOrderNo(){
    return this.preOrderNo;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setShopCode(String shopCode){
    this.shopCode = shopCode;
    }
    public String getShopCode(){
    return this.shopCode;
    }
    public void setShopName(String shopName){
    this.shopName = shopName;
    }
    public String getShopName(){
    return this.shopName;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseClassify(String warehouseClassify){
    this.warehouseClassify = warehouseClassify;
    }
    public String getWarehouseClassify(){
    return this.warehouseClassify;
    }
    public void setTotalQuantity(BigDecimal totalQuantity){
    this.totalQuantity = totalQuantity;
    }
    public BigDecimal getTotalQuantity(){
    return this.totalQuantity;
    }
    public void setShippingCompanyCode(String shippingCompanyCode){
    this.shippingCompanyCode = shippingCompanyCode;
    }
    public String getShippingCompanyCode(){
    return this.shippingCompanyCode;
    }
    public void setShippingCompany(String shippingCompany){
    this.shippingCompany = shippingCompany;
    }
    public String getShippingCompany(){
    return this.shippingCompany;
    }
    public void setShippingCode(String shippingCode){
    this.shippingCode = shippingCode;
    }
    public String getShippingCode(){
    return this.shippingCode;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public String getReceiveWarehouseCode() {
        return receiveWarehouseCode;
    }

    public void setReceiveWarehouseCode(String receiveWarehouseCode) {
        this.receiveWarehouseCode = receiveWarehouseCode;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public List<CsOutResultOrderDetailRespDto> getDetailRespDtos() {
        return detailRespDtos;
    }

    public void setDetailRespDtos(List<CsOutResultOrderDetailRespDto> detailRespDtos) {
        this.detailRespDtos = detailRespDtos;
    }

    public String getWmsMergeDocumentNo() {
        return wmsMergeDocumentNo;
    }

    public void setWmsMergeDocumentNo(String wmsMergeDocumentNo) {
        this.wmsMergeDocumentNo = wmsMergeDocumentNo;
    }

    public String getJoinMergeDocumentNo() {
        return joinMergeDocumentNo;
    }

    public void setJoinMergeDocumentNo(String joinMergeDocumentNo) {
        this.joinMergeDocumentNo = joinMergeDocumentNo;
    }
}
