package com.dtyunxi.tcbj.api.dto.response.es;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CsOtherStorageOrderRespVo extends BaseVo implements Serializable {
    private Long id;
    /**
     * 其他出入库单据编号
     */
    private String storageOrderNo;
    /**
     * 外部单号
     */
    private String externalOrderNo;
    /**
     * 审核单号
     */
    private String auditOrderNo;
    /**
     * 前置单号
     */
    private String preOrderNo;
    /**
     * 1:PCP 2:CSP
     */
    private String orderSrc;
    /**
     * 其他单据类型 other_out :出库 other_in:入库
     */
    private String type;
    /**
     * 业务类型
     */
    private Long businessType;
    /**
     * 库存组织
     */
    private String organization;
    /**
     * 库存组织id
     */
    private Long organizationId;
    /**
     * 发货逻辑仓库id
     */
    private Long warehouseId;
    /**
     * 发货逻辑仓库编码
     */
    private String warehouseCode;
    /**
     * 发货逻辑仓库名称
     */
    private String warehouseName;
    /**
     * 客户编码
     */
    private String customerCode;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 单据状态
     */
    private String orderStatus;
    /**
     * 收货人
     */
    private String consignee;
    /**
     * 联系电话
     */
    private String phone;
    /**
     * 总数量
     */
    private BigDecimal totalQuantity;
    /**
     * 总重量
     */
    private BigDecimal totalWeight;
    /**
     * 总体积
     */
    private BigDecimal totalVolume;
    /**
     * 总箱数
     */
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     */
    private BigDecimal mergeQuantity;
    /**
     * 省code
     */
    private String provinceCode;
    /**
     * 省
     */
    private String provinceName;
    /**
     * 市code
     */
    private String cityCode;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区code
     */
    private String areaCode;
    /**
     * 区
     */
    private String areaName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 摘要
     */
    private String message;
    /**
     * 备注
     */
    private String remark;
    protected String createPerson;
    protected Date createTime;
    protected String updatePerson;
    protected Date updateTime;
    protected Integer dr;

    private Date bizDate;

    @ApiModelProperty(name = "stringCodeResult", value = "串码验证结果 0-未读取;1-读码异常;2-读码成功")
    private Integer stringCodeResult;

    @ApiModelProperty(name = "stringCodeTime", value = "串码更新时间")
    private Date stringCodeTime;

    /**
     * 物流公司名称
     */
    private String shippingCompany;
    /**
     * 物流单号
     */
    private String shippingCode;
    /**
     * 托运单号
     */
    private String consignmentNo;
    /**
     * 承运方式
     */
    private String shippingType;
    /**
     * 出库通知单号
     */
    private String outNoticeNo;

    @ApiModelProperty(name = "mergeOrderNo", value = "合单单号")
    private String mergeOrderNo;

    @ApiModelProperty(name = "costOrgCode", value = "财务组织编号")
    private String costOrgCode;

    @ApiModelProperty(name = "costOrgName", value = "财务组织名称")
    private String costOrgName;

    @ApiModelProperty(name="totalOrder", value = "是否总单")
    private Integer totalOrder;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "发货物理仓编码")
    private String deliveryPhysicsWarehouseCode;

    @ApiModelProperty(name = "deliveryPhysicsWarehouseName", value = "发货物理仓名字")
    private String deliveryPhysicsWarehouseName;
}
