package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PhysicWarehouseStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicWarehouseStatisticsExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicWarehouseStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 物理仓板数统计服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"物理仓板数统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IPhysicWarehouseStatisticsQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/physicWarehouseStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface IPhysicWarehouseStatisticsQueryApi {

    /**
    * 根据id查询物理仓板数统计
    *
    * @param id 物理仓板数统计id
    * @return   物理仓板数统计数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物理仓板数统计", notes = "根据id查询物理仓板数统计")
    RestResponse<PhysicWarehouseStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 物理仓板数统计分页数据
    *
    * @param filter   物理仓板数统计查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 物理仓板数统计分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "物理仓板数统计分页数据", notes = "根据filter查询条件查询物理仓板数统计数据，filter=PhysicWarehouseStatisticsReqDto")
    RestResponse<PageInfo<PhysicWarehouseStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 物理仓板数统计分页数据
     *
     *
     * @return 物理仓板数统计分页数据
     */
    @PostMapping("/physicWarehouseStatistics")
    @ApiOperation(value = "物理仓板数统计分页数据", notes = "物理仓板数统计分页数据")
    RestResponse<PhysicWarehouseStatisticsExtRespDto> queryPhysicWarehouseStatistics(@RequestBody List<String> codeList);


    @GetMapping("/queryPage")
    @ApiOperation(value = "实时查询物理仓板数统计接口", notes = "实时查询物理仓板数统计接口")
    RestResponse<List<PhysicWarehouseStatisticsRespDto>> queryPage();


}
