package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 寻源策略Eo对象
 *
 * @author haoxiao
 * @since 2022-04-18
 */
@Data
@ApiModel(value = "ClueReportReqDto", description = "寻源策略Eo对象")
public class ClueReportReqDto extends BaseDto {
    /**
     *
     */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
     * 策略名
     */
    @ApiModelProperty(name = "clueName", value = "策略名")
    private String ruleName;
    /**
     * 策略编码
     */
    @ApiModelProperty(name = "clueCode", value = "策略编码")
    private String ruleCode;
    /**
     * 策略优先级
     */
    @ApiModelProperty(name = "rulePriority", value = "策略优先级")
    private Integer rulePriority;
    /**
     * 策略生效开始时间
     */
    @ApiModelProperty(name = "startTime", value = "策略生效开始时间")
    private Date startTime;
    /**
     * 策略生效结束时间
     */
    @ApiModelProperty(name = "endTime", value = "策略生效结束时间")
    private Date endTime;
    /**
     * 策略启用状态
     */
    @ApiModelProperty(name = "ruleStatus", value = "策略启用状态")
    private String ruleStatus;
    /**
     * 适用订单渠道
     */
    @ApiModelProperty(name = "applicableChannelCodes", value = "适用订单渠道")
    private List<String> applicableChannelCodes;
    /**
     * 适用单据类型
     */
    @ApiModelProperty(name = "applicableDocumentTypes", value = "适用单据类型")
    private List<String> applicableDocumentTypes;
    /**
     * 适用客户
     */
    @ApiModelProperty(name = "applicableCustomersCodes", value = "适用客户")
    private List<String> applicableCustomersCodes;
    /**
     * 适用目标逻辑仓
     */
    @ApiModelProperty(name = "applicableLogicalWarehouseCodes", value = "适用目标逻辑仓")
    private List<String> applicableLogicalWarehouseCodes;

    /**
     *  更新时间开始
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间开始")
    private Date updateTimeStart;
    /**
     *  更新时间结束
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间结束")
    private Date updateTimeEnd;

    @ApiModelProperty(name="applicableOrganizationCodes", value = "适用销售组织")
    private List<String> applicableOrganizationCodes = null;

}
