package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsNoticeWmsStatusReqDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsNoticeWmsStatusRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryNoticeOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 发货通知单服务接口
*
* @author wude
* @since 2022-03-08
*/
@Api(tags = {"发货通知单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/deliveryNoticeOrder", url = "${tcbj.center.report.api:}")
public interface IDeliveryNoticeOrderQueryApi {

    /**
    * 根据id查询发货通知单
    *
    * @param id 发货通知单id
    * @return   发货通知单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询发货通知单", notes = "根据id查询发货通知单")
    RestResponse<DeliveryNoticeOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 发货通知单分页数据
    *
    * @param filter   发货通知单查询条件
    * @return 发货通知单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "发货通知单分页数据", notes = "根据filter查询条件查询发货通知单数据，filter=DeliveryNoticeOrderReqDto")
    RestResponse<PageInfo<DeliveryNoticeOrderRespDto>> queryByPage(@RequestBody DeliveryNoticeOrderReqDto filter);

    /**
     * 出库/入库通知单wms状态分页数据
     *
     * @return 出库/入库通知单wms状态分页数据
     */
    @PostMapping("/queryNoticeWmsPage")
    @ApiOperation(value = "出库/入库通知单wms状态分页数据", notes = "根据filter查询条件查询出库/入库通知单wms状态数据，filter=CsNoticeWmsStatusReqDto")
    RestResponse<PageInfo<CsNoticeWmsStatusRespDto>> queryNoticeWmsPage(@RequestBody CsNoticeWmsStatusReqDto csNoticeWmsStatusReqDto);

}
