package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * 仓储账单分摊计算方式
 *
 * @author lius5
 */
public enum CalculateWayEnum {

    VOLUME(0, "体积"),
    SUPPORT(1, "板数"),
    ;

    private Integer key;

    private String desc;

    public Integer getKey() {
        return key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    CalculateWayEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static CalculateWayEnum keyOfEnum(Integer key) {
        for (CalculateWayEnum calculateWayEnum : CalculateWayEnum.values()) {
            if(calculateWayEnum.getKey().equals(key)){
                return calculateWayEnum;
            }
        }
        return null;
    }
}
