package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

public enum InsuranceBusinessTypeEnum {
    ORDER_SALES_OUT("order_sales_out", "订单销售出库"),
    ALLOT_OUT("allot_out", "调拨单（普通调拨）跨物理仓"),
    ALLOT_OUT_ONLY("allot_out_only", "库存调拨单（调拨出库）"),
    PURCHASE_REFUND("purchase_refund", "采购订单退货"),
    OUTSOURCE_REFUND("outsource_refund", "委外订单退货"),
    OTHER_OUT("other_out", "其他出库"),

    NUTRITION_INTEGRAL("nutrition_integral","营养家积分"),
    ACTIVITY_ORDER("activity_order","活动订单"),
    AGENCY_ORDER("agency_order","经销订单"),
    CLAIM_REISSUE("claim_reissue","仓库索赔补发"),
    COMPENSATION_ORDER("compensation_order","索赔补发"),
    CUSTOMER_REFUNDING_ORDER("customer_refunding_order","消费者退换货"),
    OTHER_OUT_STOCK("other_out_stock","其他出库单"),
    PRESALE_ORDER("presale_order","预售订单"),
    QUALITY_REFUNDING_ORDER("quality_refunding_order","质量退换货"),
    REPLENISHMENT_ORDER("replenishment_order","货补订单"),
    SECONDARY_DISTRIBUTION("secondary_distribution","二级分销"),

    ALLOT_BC_EFFICACY("allot_bc_efficacy", "调拨单（B-C仓调拨）");

    private String code;
    private String desc;

    private InsuranceBusinessTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static InsuranceBusinessTypeEnum getByCode(String code) {
        return StringUtils.isBlank(code) ? null :  Arrays.asList(values()).stream().filter((e) -> {
            return e.getCode().equals(code);
        }).findAny().orElse( null);
    }
}