package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
 * 发/收货结果单Eo对象
 *
 * @author by_liusong
 * @since 2022-08-02
 */
@ApiModel(value = "DeliveryResultOrderRespDto", description = "发/收货结果单Eo对象")
@Data
public class DeliveryResultOrderRespDto extends BaseRespDto{
    /**
     *  主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     *  发/收货通知单号
     */
    @ApiModelProperty(name = "documentNo", value = "发/收货通知单号")
    private String documentNo;
    /**
     *  wms单号（已废弃）
     */
    @ApiModelProperty(name = "wmsNo", value = "wms单号（已废弃）")
    private String wmsNo;
    /**
     *  关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     *  前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     *  外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     *  wms单号
     */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号")
    private String wmsOrderNo;
    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     *  业务单据表名
     */
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;
    /**
     *  单据类型：delivery-发货结果单，receive-收货结果单
     */
    @ApiModelProperty(name = "orderType", value = "单据类型：delivery-发货结果单，receive-收货结果单")
    private String orderType;
    /**
     *  单据状态,待定
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     *  店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     *  发货仓库ID（已废弃）
     */
    @ApiModelProperty(name = "warehouseId", value = "发货仓库ID（已废弃）")
    private Long warehouseId;
    /**
     *  发货仓库编码（已废弃）
     */
    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码（已废弃）")
    private String warehouseCode;
    /**
     *  发货仓库名称（已废弃）
     */
    @ApiModelProperty(name = "warehouseName", value = "发货仓库名称（已废弃）")
    private String warehouseName;
    /**
     *  仓库分类,physics-物理仓,logic-逻辑仓（已废弃）
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String warehouseClassify;
    /**
     *  收货仓库ID（已废弃）
     */
    @ApiModelProperty(name = "receiveWarehouseId", value = "收货仓库ID（已废弃）")
    private Long receiveWarehouseId;
    /**
     *  收货仓库编码（已废弃）
     */
    @ApiModelProperty(name = "receiveWarehouseCode", value = "收货仓库编码（已废弃）")
    private String receiveWarehouseCode;
    /**
     *  收货仓库名称（已废弃）
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称（已废弃）")
    private String receiveWarehouseName;
    /**
     *  收货仓库分类,physics-物理仓,logic-逻辑仓（已废弃）
     */
    @ApiModelProperty(name = "receiveWarehouseClassify", value = "收货仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String receiveWarehouseClassify;
    /**
     *  发货逻辑仓库编码
     */
    @ApiModelProperty(name = "deliveryLogicWarehouseCode", value = "发货逻辑仓库编码")
    private String deliveryLogicWarehouseCode;
    /**
     *  发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryLogicWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryLogicWarehouseName;
    /**
     *  收货逻辑仓库编码
     */
    @ApiModelProperty(name = "receiveLogicWarehouseCode", value = "收货逻辑仓库编码")
    private String receiveLogicWarehouseCode;
    /**
     *  收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveLogicWarehouseName", value = "收货逻辑仓库名称")
    private String receiveLogicWarehouseName;
    /**
     *  物理发货仓编码
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "物理发货仓编码")
    private String deliveryPhysicsWarehouseCode;
    /**
     *  物理发货仓名字
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseName", value = "物理发货仓名字")
    private String deliveryPhysicsWarehouseName;
    /**
     *  收货物理仓编码
     */
    @ApiModelProperty(name = "receivePhysicsWarehouseCode", value = "收货物理仓编码")
    private String receivePhysicsWarehouseCode;
    /**
     *  收货物理仓名字
     */
    @ApiModelProperty(name = "receivePhysicsWarehouseName", value = "收货物理仓名字")
    private String receivePhysicsWarehouseName;
    /**
     *  发货总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "发货总数量")
    private BigDecimal totalQuantity;
    /**
     * sku去重数量
     */
    private BigDecimal totalSku;
    /**
     *  拼箱数
     */
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     *  拼箱数
     */
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
     *  物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)
     */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;
    /**
     *  物流公司名称
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;
    /**
     *  运输方式
     */
    @ApiModelProperty(name = "shippingType", value = "运输方式")
    private String shippingType;
    /**
     *  物流公司运单号（存储母单号）
     */
    @ApiModelProperty(name = "shippingCode", value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /**
     *  备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     *  组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     *  组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     *  版本：0.迁移旧数据，1.一期迭代二，2.二期
     */
    @ApiModelProperty(name = "version", value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    @ApiModelProperty(name = "resultOrderDetailRespDtoList", value = "明细")
    private List<DeliveryResultOrderDetailRespDto> resultOrderDetailRespDtoList;
    /**
     *  业务时间
     */
    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    /**
     * 发货通知单
     */
    @ApiModelProperty(name = "noticeNo", value = "发货通知单")
    private String noticeNo;

    private String deliveryRemark;

    private String remarkNo;

    private String sellerRemark;


}
