package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * 分拣费用类型枚举
 */
public enum SortingBillType {
    /**
     * 计费类型的数据来源：
     * 1）人工导入和系统生成的单据默认是常规计费；
     * 2）自动分摊是内部交易；
     * 3）手工分摊是人工分摊
     */
    REGULAR_BILLING("REGULAR_BILL", "常规计费"),
    INTERNAL_TRANSACTION("INTERNAL_TRANSACTION", "内部交易"),
    MANUAL_ALLOCATION("MANUAL_ALLOCATION", "人工分摊");

    private final String code;
    private final String description;

    SortingBillType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static SortingBillType getByCode(String code) {
        for (SortingBillType type : values()) {
            if (type.code == code) {
                return type;
            }
        }
        return null;
    }

    public boolean equalsCode(String code) {
        return this.getCode().equals(code);
    }

    /**
     * 判断编码是否存在
     */
    public static boolean isExist(String code) {
        for (SortingBillType type : values()) {
            if (type.equalsCode(code)) {
                return true;
            }
        }
        return false;
    }

}
