package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>Tile </p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
public class FinLogisticsReportEditReqDto implements Serializable {

    @ApiModelProperty(name = "mergeFlag", value = "合单标识，true 合单 false 非合单")
    private Boolean mergeFlag = false;

    @ApiModelProperty(name = "editId",value = "编辑Id mergeFlag = true editId 传列表parentId字段值；mergeFlag = false editId传列表ID值")
    @NotNull(message = "编辑ID不能为空")
    private Long editId;

    @ApiModelProperty(value = "特殊费用类型")
    private String specialType;

    @ApiModelProperty(value = "特殊费用")
    private BigDecimal specialAmount;

    @ApiModelProperty(value = "备注")
    private String remark;


    /**
     *  省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;
    /**
     *  城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    @ApiModelProperty(name = "cityCode", value = "省份编码")
    private String cityCode;

    /**
     *  区/县
     */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;
    @ApiModelProperty(name = "areaCode", value = "区/县编码")
    private String areaCode;

    @ApiModelProperty(name = "harvestAddress", value = "详细地址")
    private String harvestAddress;

    private BigDecimal totalTransportAmount;
}
