package com.dtyunxi.tcbj.api.dto;

import com.yunxi.dg.base.commons.dto.CanExtensionDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description SortingExpenseDetailDto-分拣费用明细报表传输对象
 * @Author 代码生成器
 * @Date 2025-08-26 14:59:24
 * @TemplateVersion 1.0.0
 * @MD5Code 1dc39ac3bfaa29ca1901c132abc317bf
 **/
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "SortingExpenseChargingDto", description = "分拣计费明细报表传输对象")
public class SortingExpenseChargingDto extends CanExtensionDto<SortingExpenseChargingDtoExtension> {
    @ApiModelProperty(name = "outWarehouseTime", value = "出库时间")
    private Date outWarehouseTime;

    @ApiModelProperty(name = "wmsOrderNo", value = "WMS出库单号")
    private String wmsOrderNo;

    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;

    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库仓编码")
    private String outLogicWarehouseCode;

    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库仓名称")
    private String outLogicWarehouseName;

    @ApiModelProperty(name = "outOrganizationId", value = "调出库存组织id")
    private String outOrganizationId;

    @ApiModelProperty(name = "outOrganizationName", value = "调出库存组织")
    private String outOrganizationName;

    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库仓编码")
    private String inLogicWarehouseCode;

    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库仓名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "inOrganizationId", value = "调入库存组织id")
    private String inOrganizationId;

    @ApiModelProperty(name = "inOrganizationName", value = "调入库存组织")
    private String inOrganizationName;

    @ApiModelProperty(name = "expenseOrganizationId", value = "费用归属组织id")
    private String expenseOrganizationId;

    @ApiModelProperty(name = "expenseOrganizationName", value = "费用归属组织")
    private String expenseOrganizationName;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;

    @ApiModelProperty(name = "doneQuantity", value = "出库数量")
    private BigDecimal doneQuantity;

    @ApiModelProperty(name = "bigRatio", value = "装箱数")
    private Long bigRatio;

    @ApiModelProperty(name = "smallRatio", value = "小箱瓶数")
    private Long smallRatio;

    @ApiModelProperty(name = "bigBoxNum", value = "大箱数量")
    private BigDecimal bigBoxNum;

    @ApiModelProperty(name = "smallBoxNum", value = "小箱数量")
    private BigDecimal smallBoxNum;

    @ApiModelProperty(name = "boxNum", value = "个数")
    private BigDecimal boxNum;

    @ApiModelProperty(name = "adjustType", value = "调整类型；1：增加；2：减少")
    private Long adjustType;

    @ApiModelProperty(name = "adjustNum", value = "调整金额")
    private BigDecimal adjustNum;

    @ApiModelProperty(name = "adjustRemarks", value = "调整备注")
    private String adjustRemarks;

    @ApiModelProperty(name = "sortingNum", value = "分拣费")
    private BigDecimal sortingNum;

    @ApiModelProperty(name = "importUpdatePerson", value = "最后修改人")
    private String importUpdatePerson;

    @ApiModelProperty(name = "importUpdateTime", value = "最后修改时间")
    private Date importUpdateTime;

    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;

    @ApiModelProperty(name = "abnormal", value = "是否异常，0:正常，1异常")
    private Integer abnormal;

    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "endProvince", value = "目的省")
    private String endProvince;

    @ApiModelProperty(name = "endProvinceCode", value = "目的省编码")
    private String endProvinceCode;

    @ApiModelProperty(name = "endCity", value = "目的市")
    private String endCity;

    @ApiModelProperty(name = "endCityCode", value = "目的市编码")
    private String endCityCode;

    @ApiModelProperty(name = "easOrderNo", value = "EAS单号")
    private String easOrderNo;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "placedFlag", value = "是否归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "WMS合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "relevanceNo", value = "业务单号")
    private String relevanceNo;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outDocumentNo", value = "出库通知单")
    private String outDocumentNo;

    @ApiModelProperty(name = "allocationQuantity", value = "分摊数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty(name = "apportionFee", value = "分摊分拣费")
    private BigDecimal apportionFee;

    @ApiModelProperty(name = "billingOrgCode", value = "计费组织编码")
    private String billingOrgCode;

    @ApiModelProperty(name = "billingOrgName", value = "计费组织名称")
    private String billingOrgName;

    @ApiModelProperty(name = "feeId", value = "关联主表id")
    private Long feeId;

    @ApiModelProperty(name = "costType", value = "计费类型DailyDeliveryReportCostBelongDetailCostTypeEnum")
    private String costType;

    @ApiModelProperty(name = "costTypeName", value = "计费类型名称")
    private String costTypeName;

    @ApiModelProperty(name = "stockApportionFlag", value = "是否股份分摊:0=非股份分摊,1=是股份分摊")
    private Integer stockApportionFlag;

}