package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * @Auther: xitao
 * @since: 0.1.0
 */
public enum BusinessTypeEnum {

    /**
     * 普通调拨
     **/
    ALLOT_OUT("allot_out", "普通调拨"),

    /**
     * 调拨单（内部交易）
     **/
    INTERNAL_DEAL("internal_deal", "调拨单（内部交易）"),

    /**
     * 调拨单（待检转合格）
     **/
    INSPECTION_QUALIFIED("inspection_qualified", "调拨单（待检转合格）"),

    /**
     * 近效期/失效商品调拨
     **/
    ALLOT_LOSE_EFFICACY("allot_lose_efficacy", "近效期/失效商品调拨"),

    /**
     * B-C仓调拨
     **/
    ALLOT_BC_EFFICACY("allot_bc_efficacy", "B-C仓调拨"),

    /**
     * 盘点单
     **/
    CHECK_STOCK("check_stock", "盘点单"),

    /**
     * 批次号调整单
     **/
    BATCH_ADJUST("batch_adjust", "批次号调整单"),

    /**
     * 采购单
     **/
    PURCHASE("purchase", "采购单"),

    /**
     * 委外单
     **/
    OUTSOURCE("outsource", "委外单"),

    /**
     * 采购,委外,生产单
     **/
    PRODUCTION("production", "生产单"),

    /**
     * 采购退货单
     **/
    PURCHASE_REFUND("purchase_refund", "采购退货单"),

    /**
     * 委外退货单
     **/
    OUTSOURCE_REFUND("outsource_refund", "委外退货单"),

    /**
     * 其他入库单
     **/
    OTHER_IN("other_in", "其他入库单"),

    /**
     * 其他出库单
     **/
    OTHER_OUT("other_out", "其他出库单"),

    NUTRITION_INTEGRAL("nutrition_integral","营养家积分"),
    ACTIVITY_ORDER("activity_order","活动订单"),
    AGENCY_ORDER("agency_order","经销订单"),
    CLAIM_REISSUE("claim_reissue","仓库索赔补发"),
    COMPENSATION_ORDER("compensation_order","索赔补发"),
    CUSTOMER_REFUNDING_ORDER("customer_refunding_order","消费者退换货"),
    OTHER_OUT_STOCK("other_out_stock","其他出库单"),
    PRESALE_ORDER("presale_order","预售订单"),
    QUALITY_REFUNDING_ORDER("quality_refunding_order","质量退换货"),
    REPLENISHMENT_ORDER("replenishment_order","货补订单"),
    SECONDARY_DISTRIBUTION("secondary_distribution","二级分销"),

    INTEGRAL_ORDER("integral_order", "经销商积分"),
    MAIYOU_ALLOT_OUT("maiyou_allot_out", "麦优库存调拨单"),
    MAIYOU_BC_ALLOT("maiyou_bc_allot", "麦优BC调拨"),
    MORE_DISPATCHER("more_dispatcher", "多收"),
    LESS_DISPATCHER("less_dispatcher", "少收"),
    ALLOT_SALE("allot_sale", "销售调拨单"),
    MAIYOU_ALLOT("maiyou_allot", "麦优销售调拨单"),
    ALLOT_SALE_BH("allot_sale_bh", "销售补货调拨单"),
    IN_TRANSIT_ADJUSTMENT_IN("in_transit_adjustment_in", "在途库存入库"),
    IN_TRANSIT_ADJUSTMENT_OUT("in_transit_adjustment_out", "在途库存出库"),
    IN_TRANSIT_ADJUSTMENT("in_transit_adjustment", "在途库存调整单"),
    PRODUCT_REPAIR("product_repair", "生产返修退厂单"),
    SHARE_GOODS_ORDER("share_goods_order", "分货单"),
    SPECIAL_CHANNEL_ORDER("special_channel_order","特渠单"),
    COMMON_ORDER("common_order", "普通订单"),


    CC_ALLOT("cc_allot", "cc调拨"),
    BC_ALLOT("bc_allot", "bc调拨"),
    CB_ALLOT("cb_allot", "cb调拨"),




    /**
     * 订单销售出库
     **/
    ORDER_SALES_OUT("order_sales_out", "订单销售出库");

    BusinessTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private final String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (BusinessTypeEnum value : BusinessTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }

    public static BusinessTypeEnum getStatusByCode(String code) {
        for (BusinessTypeEnum value : BusinessTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
