package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "InspectionReleaseRecordRespDto", description = "放行单Eo对象")
@Data
public class InspectionReleaseRecordRespDto extends BaseRespDto {
    /**
     *  主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     *  放行单号
     */
    @ApiModelProperty(name = "inspectionReleaseNo", value = "放行单号")
    private String inspectionReleaseNo;
    /**
     *  SKU code
     */
    @ApiModelProperty(name = "skuCode", value = "SKU code")
    private String skuCode;
    /**
     *  SKU 名称
     */
    @ApiModelProperty(name = "skuName", value = "SKU 名称")
    private String skuName;
    /**
     *  SKU 规格
     */
    @ApiModelProperty(name = "skuSpec", value = "SKU 规格")
    private String skuSpec;
    /**
     *  批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     *  计划放行数量
     */
    @ApiModelProperty(name = "planReleaseNum", value = "计划放行数量")
    private BigDecimal planReleaseNum;
    /**
     *  放行数量
     */
    @ApiModelProperty(name = "releaseNum", value = "放行数量")
    private BigDecimal releaseNum;

    @ApiModelProperty(name = "status", value = "放行记录状态")
    private String status;

    @ApiModelProperty(name = "statusName", value = "放行记录状态")
    private String statusName;

    @ApiModelProperty(name = "remark", value = "失败原因")
    private String remark;

    @ApiModelProperty(name = "statusName", value = "放行记录类型")
    private String taskType;

    @ApiModelProperty(name = "taskTypeName", value = "放行记录类型")
    private String taskTypeName;

    @ApiModelProperty(name = "executeTransferNo", value = "放行调拨单号")
    private String executeTransferNo;

    @ApiModelProperty(name = "executeTransferNoStatus", value = "放行调拨单号状态")
    private String executeTransferNoStatus;

    @ApiModelProperty(name = "outLogicWarehouseCode", value = "调出逻辑仓编码")
    private String outLogicWarehouseCode;

    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓")
    private String outLogicWarehouseName;

    @ApiModelProperty(name = "inLogicWarehouseCode", value = "调入逻辑仓编码")
    private String inLogicWarehouseCode;

    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓")
    private String inLogicWarehouseName;


    @ApiModelProperty(name = "inspectionTransferNo", value = "前置调拨单号")
    private String inspectionTransferNo;

    @ApiModelProperty(name = "inspectionTransferNoStatus", value = "前置调拨单号状态")
    private String inspectionTransferNoStatus;

    @ApiModelProperty(name = "taskNo", value = "放行记录编号")
    private String taskNo;

    @ApiModelProperty(name = "noticeNo", value = "通知单单号")
    private String noticeNo;

}
