package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
* 出库通知单Eo对象
*
* @author wude
* @since 2022-03-10
*/
@ApiModel(value = "OutNoticeOrderRespDto", description = "出库通知单Eo对象")
public class OutNoticeOrderRespDto extends BaseRespDto {
    /**
    *  出库通知单号
    */
    @ApiModelProperty(name = "documentNo", value = "出库通知单号")
    private String documentNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
    *  外部单号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
    *  发货店铺ID
    */
    @ApiModelProperty(name = "shopId", value = "发货店铺ID")
    private Long shopId;
    /**
    *  发货店铺编码
    */
    @ApiModelProperty(name = "shopCode", value = "发货店铺编码")
    private String shopCode;
    /**
    *  发货店铺名称
    */
    @ApiModelProperty(name = "shopName", value = "发货店铺名称")
    private String shopName;
    /**
    *  发货仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "发货仓库ID")
    private Long warehouseId;
    /**
    *  发货逻辑仓库编码
    */
    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货逻辑仓库编码")
    private String deliveryWarehouseCode;
    /**
    *  发货逻辑仓库名称
    */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryWarehouseName;
    /**
    *  出库总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "出库总数量")
    private BigDecimal totalQuantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 收货逻辑仓库编码
     */
    @ApiModelProperty(name = "receiveWarehouseCode", value = "收货逻辑仓库编码")
    private String receiveWarehouseCode;
    /**
     *  收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货逻辑仓库名称")
    private String receiveWarehouseName;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库逻辑仓库编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库逻辑仓库名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "入库逻辑仓库编码")
    private String inPhysicsWarehouseCode;

    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "入库逻辑仓库名称")
    private String inPhysicsWarehouseName;

    public void setDocumentNo(String documentNo){
    this.documentNo = documentNo;
    }
    public String getDocumentNo(){
    return this.documentNo;
    }
    public void setRelevanceNo(String relevanceNo){
    this.relevanceNo = relevanceNo;
    }
    public String getRelevanceNo(){
    return this.relevanceNo;
    }
    public void setPreOrderNo(String preOrderNo){
    this.preOrderNo = preOrderNo;
    }
    public String getPreOrderNo(){
    return this.preOrderNo;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setShopCode(String shopCode){
    this.shopCode = shopCode;
    }
    public String getShopCode(){
    return this.shopCode;
    }
    public void setShopName(String shopName){
    this.shopName = shopName;
    }
    public String getShopName(){
    return this.shopName;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setTotalQuantity(BigDecimal totalQuantity){
    this.totalQuantity = totalQuantity;
    }
    public BigDecimal getTotalQuantity(){
    return this.totalQuantity;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public String getReceiveWarehouseCode() {
        return receiveWarehouseCode;
    }

    public void setReceiveWarehouseCode(String receiveWarehouseCode) {
        this.receiveWarehouseCode = receiveWarehouseCode;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public String getOutPhysicsWarehouseCode() {
        return outPhysicsWarehouseCode;
    }

    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode) {
        this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }

    public String getOutPhysicsWarehouseName() {
        return outPhysicsWarehouseName;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }

    public String getInPhysicsWarehouseCode() {
        return inPhysicsWarehouseCode;
    }

    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode) {
        this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }

    public String getInPhysicsWarehouseName() {
        return inPhysicsWarehouseName;
    }

    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName) {
        this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }
}
