package com.dtyunxi.tcbj.api.dto.response;

import lombok.Data;

import java.io.Serializable;

@Data
public class InspectionReleaseLogicInventoryCountRespDto implements Serializable {
    /**
     * 前端tab页标记
     * wait_release(待放行),
     * pre_release(预放行),
     * pre_release_error(预放行-异常),
     * has_release(已放行),
     * unqualified(待放行-不合格),
     * over_2days_not_submit(待放行-超2天未提单),
     * over_7days_not_report(待放行-超7天未出报告),
     * over_3days_not_release(待放行-超3天未放行),
     * balance_gt_plan(待放行-在库比计划多),
     * balance_lt_plan(待放行-在库比计划少),
     * pre_release_over_7days_not_report(预放行-超7天未出报告)
     * wait_release_plan_in_diff(待放行-计划与入库差异)
     * pre_release_plan_in_diff(预放行-计划与入库差异)
     * has_release_plan_release_diff(已放行-计划与实际差异)
     */
    private Long waitReleaseCount;
    private Long preReleaseCount;
    private Long preReleaseErrorCount;
    private Long hasReleaseCount;
    private Long unqualifiedCount;
    private Long over2DaysNotSubmitCount;
    private Long over7DaysNotReportCount;
    private Long over3DaysNotReleaseCount;
    private Long balanceGtPlanCount;
    private Long balanceLtPlanCount;
    private Long releaseDiffCount;
    private Long preReleaseOver7daysNotReportCount;
    private Long waitReleasePlanInDiffCount;
    private Long preReleasePlanInDiffCount;
    private Long hasReleasePlanReleaseDiffCount;
}
