package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 物理仓库存表Eo对象
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "PhysicsInventoryRespDto", description = "物理仓库存表Eo对象")
public class PhysicsInventoryRespDto extends ResponseDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "allocate", value = "已分配库存")
    private BigDecimal allocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "activityAllocate", value = "活动分配库存")
    private BigDecimal activityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "transfer", value = "已调拨库存")
    private BigDecimal transfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "completed", value = "已完成库存")
    private BigDecimal completed;
    /**
    *  可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
     *  待收库存
     */
    @ApiModelProperty(name = "futureIn", value = "待收库存")
    private BigDecimal futureIn;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品条码
     */
    @ApiModelProperty(name = "itemBarCode", value = "商品条码")
    private String itemBarCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setCargoId(Long cargoId){
    this.cargoId = cargoId;
    }
    public Long getCargoId(){
    return this.cargoId;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setBatchType(String batchType){
    this.batchType = batchType;
    }
    public String getBatchType(){
    return this.batchType;
    }
    public void setBalance(BigDecimal balance){
    this.balance = balance;
    }
    public BigDecimal getBalance(){
    return this.balance;
    }
    public void setPreempt(BigDecimal preempt){
    this.preempt = preempt;
    }
    public BigDecimal getPreempt(){
    return this.preempt;
    }
    public void setAllocate(BigDecimal allocate){
    this.allocate = allocate;
    }
    public BigDecimal getAllocate(){
    return this.allocate;
    }
    public void setActivityAllocate(BigDecimal activityAllocate){
    this.activityAllocate = activityAllocate;
    }
    public BigDecimal getActivityAllocate(){
    return this.activityAllocate;
    }
    public void setIntransit(BigDecimal intransit){
    this.intransit = intransit;
    }
    public BigDecimal getIntransit(){
    return this.intransit;
    }
    public void setTransfer(BigDecimal transfer){
    this.transfer = transfer;
    }
    public BigDecimal getTransfer(){
    return this.transfer;
    }
    public void setCompleted(BigDecimal completed){
    this.completed = completed;
    }
    public BigDecimal getCompleted(){
    return this.completed;
    }
    public void setAvailable(BigDecimal available){
    this.available = available;
    }
    public BigDecimal getAvailable(){
    return this.available;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setExpireTime(Date expireTime){
    this.expireTime = expireTime;
    }
    public Date getExpireTime(){
    return this.expireTime;
    }
    public void setProduceTime(Date produceTime){
    this.produceTime = produceTime;
    }
    public Date getProduceTime(){
    return this.produceTime;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Integer getExpired() {
        if (this.getExpireTime()==null){
            return 0;
        }else{
            if (this.getExpireTime().before(DateUtil.getSysDate())){
                return 1;
            }else{
                return 0;
            }
        }
    }

    public void setExpired(Integer expired) {
        this.expired = expired;
    }

    public String getItemLongCode() {
        return itemLongCode;
    }

    public void setItemLongCode(String itemLongCode) {
        this.itemLongCode = itemLongCode;
    }

    public String getItemBarCode() {
        return itemBarCode;
    }

    public void setItemBarCode(String itemBarCode) {
        this.itemBarCode = itemBarCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public BigDecimal getFutureIn() {
        return futureIn;
    }

    public void setFutureIn(BigDecimal futureIn) {
        this.futureIn = futureIn;
    }
}
