package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 保费明细表Eo对象
*
* @author lshaowu
* @since 2022-07-18
*/
@Data
@ApiModel(value = "ReInsurancePremiumReqDto", description = "保费明细表Eo对象")
public class ReInsurancePremiumReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  出库日期（cs_out_result_order.in_out_time）
    */
    @ApiModelProperty(name = "inOutTime", value = "出库日期（cs_out_result_order.in_out_time）")
    private Date inOutTime;
    /**
     *  单号（关联业务单号、EAS单号、出库通知单单号、出库结果单单号、托运单号、wms合单号、组合单号）
     */
    @ApiModelProperty(name = "orderNo", value = "单号（关联业务单号、EAS单号、出库通知单单号、出库结果单单号、托运单号、wms合单号、组合单号）")
    private String orderNo;
    /**
     * 暂时用不上
    *  出库结果单号（关联cs_out_result_order出入库结果单表的document_no）已出库的才需要计算
    */
    @ApiModelProperty(name = "documentNo", value = "出库结果单号（关联cs_out_result_order出入库结果单表的document_no）已出库的才需要计算")
    private String documentNo;
    /**
     * 暂时用不上
    *  关联单据号（关联cs_out_result_order出入库结果单表的relevance_no）
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号（关联cs_out_result_order出入库结果单表的relevance_no）")
    private String relevanceNo;
    /**
     *  EAS外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  业务类型（cs_out_result_order.business_type）
    */
    @ApiModelProperty(name = "businessType", value = "业务类型（cs_out_result_order.business_type）")
    private String businessType;
    /**
    *  物流公司编码(cs_out_result_order.shipping_company_code)
    */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码(cs_out_result_order.shipping_company_code)")
    private String shippingCompanyCode;
    /**
    *  物流公司名称(cs_out_result_order.shipping_company)
    */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称(cs_out_result_order.shipping_company)")
    private String shippingCompany;

    @ApiModelProperty(name = "shippingCompanyList", value = "物流公司名称集合")
    private List<String> shippingCompanyList;

    /**
    *  承运方式(cs_out_result_order.shipping_type)
    */
    @ApiModelProperty(name = "shippingType", value = "承运方式(cs_out_result_order.shipping_type)")
    private String shippingType;

    @ApiModelProperty(name = "shippingTypeList", value = "承运方式集合")
    private List<String> shippingTypeList;
    /**
    *  商品长编码【通过出库结果单号，关联查询cs_out_result_order_detail明细表的document_no字段，进而获取long_code】
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码【通过出库结果单号，关联查询cs_out_result_order_detail明细表的document_no字段，进而获取long_code】")
    private String longCode;
    /**
    *  货品名称【通过出库结果单号，关联查询cs_out_result_order_detail明细表的document_no字段，进而获取cargo_name】
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称【通过出库结果单号，关联查询cs_out_result_order_detail明细表的document_no字段，进而获取cargo_name】")
    private String cargoName;
    /**
    *  商品类型【1-产品 2-赠品 3-促销物料(商品类型只有产品和促销物料分别对应产品折扣和物料折扣】
    */
    @ApiModelProperty(name = "itemType", value = "商品类型【1-产品 2-赠品 3-促销物料(商品类型只有产品和促销物料分别对应产品折扣和物料折扣】")
    private Integer itemType;
    /**
    *  出库逻辑仓库编码（调出仓，内部销售单、其他出库单只有调出仓）：cs_out_result_order的out_logic_warehouse_code
    */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库逻辑仓库编码（调出仓，内部销售单、其他出库单只有调出仓）：cs_out_result_order的out_logic_warehouse_code")
    private String outLogicWarehouseCode;
    /**
    *  出库逻辑仓库名称。cs_out_result_order的out_logic_warehouse_name
    */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库逻辑仓库名称。cs_out_result_order的out_logic_warehouse_name")
    private String outLogicWarehouseName;
    /**
    *  入库逻辑仓库编码（调入仓，内部销售单、其他出库单没有调入仓，显示为空）cs_out_result_order的in_logic_warehouse_code
    */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓库编码（调入仓，内部销售单、其他出库单没有调入仓，显示为空）cs_out_result_order的in_logic_warehouse_code")
    private String inLogicWarehouseCode;
    /**
    *  入库逻辑仓库名称。cs_out_result_order的in_logic_warehouse_name
    */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓库名称。cs_out_result_order的in_logic_warehouse_name")
    private String inLogicWarehouseName;
    /**
    *  调出库存组织id(通过out_logic_warehouse_code找cs_logic_warehouse表查warehouse_code，获取organization_id)
    */
    @ApiModelProperty(name = "outOrganizationId", value = "调出库存组织id(通过out_logic_warehouse_code找cs_logic_warehouse表查warehouse_code，获取organization_id)")
    private Long outOrganizationId;
    /**
    *  调出库存组织名称
    */
    @ApiModelProperty(name = "outOrganizationName", value = "调出库存组织名称")
    private String outOrganizationName;
    /**
    *  调入库存组织id（内部销售单、其他出库单没有调入库存组织，显示为空）（通过out_logic_warehouse_code找cs_logic_warehouse表查warehouse_code）
    */
    @ApiModelProperty(name = "inOrganizationId", value = "调入库存组织id（内部销售单、其他出库单没有调入库存组织，显示为空）（通过out_logic_warehouse_code找cs_logic_warehouse表查warehouse_code）")
    private Long inOrganizationId;
    /**
    *  调入库存组织名称
    */
    @ApiModelProperty(name = "inOrganizationName", value = "调入库存组织名称")
    private String inOrganizationName;
    /**
    *  费用归属组织id（根据调出仓和调入仓在【系统计算-费用归属设置】页查找数据，找到则用其归属组织，找不到则默认为调出仓组织）
    */
    @ApiModelProperty(name = "costBelongOrgId", value = "费用归属组织id（根据调出仓和调入仓在【系统计算-费用归属设置】页查找数据，找到则用其归属组织，找不到则默认为调出仓组织）")
    private Long costBelongOrgId;
    /**
    *  费用归属组织名称
    */
    @ApiModelProperty(name = "costBelongOrgName", value = "费用归属组织名称")
    private String costBelongOrgName;

    @ApiModelProperty(name = "costBelongOrgNameList", value = "费用归属组织名称")
    private List<String> costBelongOrgNameList;
    /**
    *  数量【cs_out_result_order.quantity】
    */
    @ApiModelProperty(name = "quantity", value = "数量【cs_out_result_order.quantity】")
    private BigDecimal quantity;
    /**
    *  建议零售价【取自主数据管理》商品资料管理》商品长编码对应的建议零售价[与商品详情的建议零售价（元）MDM一致]】it_pcp_item.recommend_price
    */
    @ApiModelProperty(name = "recommendPrice", value = "建议零售价【取自主数据管理》商品资料管理》商品长编码对应的建议零售价[与商品详情的建议零售价（元）MDM一致]】it_pcp_item.recommend_price")
    private BigDecimal recommendPrice;
    /**
    *  投保单价（=零售价*产品折扣或物料折扣，费率和折扣通过物流公司+承运方式和当前日期找到在表【物流公司关联设置】）(为空时表示计算异常，取不到数据计算)
    */
    @ApiModelProperty(name = "insureUnitPrice", value = "投保单价（=零售价*产品折扣或物料折扣，费率和折扣通过物流公司+承运方式和当前日期找到在表【物流公司关联设置】）(为空时表示计算异常，取不到数据计算)")
    private BigDecimal insureUnitPrice;
    /**
    *  单票总价值（=数量X投保单价）(为空时表示计算异常，取不到数据计算)
    */
    @ApiModelProperty(name = "insureTotalPrice", value = "单票总价值（=数量X投保单价）(为空时表示计算异常，取不到数据计算)")
    private BigDecimal insureTotalPrice;
    /**
    *  使用费率(当前计算时使用费率，关联保险公司设置的费率)
    */
    @ApiModelProperty(name = "useInsuranceRate", value = "使用费率(当前计算时使用费率，关联保险公司设置的费率)")
    private BigDecimal useInsuranceRate;
    /**
    *  使用折扣（保存计算所使用的折扣价）
    */
    @ApiModelProperty(name = "useDiscount", value = "使用折扣（保存计算所使用的折扣价）")
    private BigDecimal useDiscount;
    /**
    *  物流商设置表id
    */
    @ApiModelProperty(name = "logisticsSetttingsId", value = "物流商设置表id")
    private Long logisticsSetttingsId;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  原因（记录计算异常失败的原因，以及计算结果说明）
    */
    @ApiModelProperty(name = "reason", value = "原因（记录计算异常失败的原因，以及计算结果说明）")
    private String reason;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /*
    * 数据正常标志
     */
    @ApiModelProperty(name = "flag",value = "数据正常标志")
    private Integer flag;

    @ApiModelProperty(name = "inOutTimeBegin", value = "出库日期起")
    private Date inOutTimeBegin;
    @ApiModelProperty(name = "inOutTimeEnd", value = "出库日期止")
    private Date inOutTimeEnd;
    /**
     *订单备注信息（关联业务单备注信息）
     */
    @ApiModelProperty(name = "orderRemark", value = "订单备注信息（关联业务单备注信息）")
    private String orderRemark;
    /**
     *客户名称（关联业务单的客户名称，无则空）
     */
    @ApiModelProperty(name = "customerName", value = "客户名称（关联业务单的客户名称，无则空）")
    private String customerName;
    /**
     *客户地址（出库结果单-收货地址）
     */
    @ApiModelProperty(name = "customerAddress", value = "客户地址（出库结果单-收货地址）")
    private String customerAddress;
    /**
     *起运地（出库结果单-调出仓地址-显示市）
     */
    @ApiModelProperty(name = "startPlace", value = "起运地（出库结果单-调出仓地址-显示市）")
    private String startPlace;
    /**
     *目的地（出库结果单-收货地址-显示市）
     */
    @ApiModelProperty(name = "endPlace", value = "目的地（出库结果单-收货地址-显示市）")
    private String endPlace;
    /**
     *目的省
     */
    @ApiModelProperty(name = "endProvince", value = "目的省")
    private String endProvince;
    /**
     *不计费原因
     */
    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;
    /**
     *是否计费,0不计费,1计费
     */
    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;
    /**
     *是否已归档,0未归档,1已归档
     */
    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    private Integer pageNum;
    private Integer pageSize;

    private String businessTypeName;

    private List<String> outPhysicsWarehouseNameList;

    @ApiModelProperty(name = "inOrganizationIdList", value = "调入库存组织ID集合")
    private List<Long> inOrganizationIdList;

    @ApiModelProperty(name = "outOrganizationIdList", value = "调出库存组织ID集合")
    private List<Long> outOrganizationIdList;

    @ApiModelProperty(name = "billType", value = "计费类型")
    private String billType;

    @ApiModelProperty(name = "billOrgCode", value = "计费组织编码")
    private String billOrgCode;

    @ApiModelProperty(name = "billOrgName", value = "计费组织名称")
    private String billOrgName;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "wmsConsignmentNoList", value = "托运单集合")
    private List<String> wmsConsignmentNoList;

    private String outDocumentNo;

    private String wmsConsignmentNo;

    private String outPhysicsWarehouseCode;

    private List<String> outPhysicsWarehouseCodeList;

    private String outPhysicsWarehouseName;

    private String receivingPerson;

    private BigDecimal claimPrice;

    private String transportNo;

    @ApiModelProperty(name = "ifApportion", value = "是否分摊；1是，0否")
    private Integer ifApportion;
}
