package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;

/**
* 库存收发明细报表Eo对象
*
* @author fengjian
* @since 2022-07-07
*/
@ApiModel(value = "InventoryDetailReportRespDto", description = "库存收发明细报表Eo对象")
public class InventoryDetailReportRespDto extends BaseRespDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticsTime", value = "统计时间")
    private Date statisticsTime;
    /**
    *  外部单号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  系统来源
    */
    @ApiModelProperty(name = "sourceSystem", value = "系统来源")
    private String sourceSystem;
    /**
    *  单据类型：out-出库结果单，in-入库结果单
    */
    @ApiModelProperty(name = "orderType", value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;
    /**
    *  出入库单号
    */
    @ApiModelProperty(name = "documentNo", value = "出入库单号")
    private String documentNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  关联业务单号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联业务单号")
    private String relevanceNo;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 入库逻辑仓库编码
     */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓库编码")
    private String logicWarehouseCode;
    /**
     * 入库逻辑仓库名称
     */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓库名称")
    private String logicWarehouseName;
    /**
     * 库存数量
     */
    @ApiModelProperty(name = "quantity", value = "库存数量")
    private BigDecimal quantity;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  单据创建时间
    */
    @ApiModelProperty(name = "noticeCreateTime", value = "单据创建时间")
    private Date noticeCreateTime;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  库存组织
    */
    @ApiModelProperty(name = "organizationName", value = "库存组织")
    private String organizationName;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setStatisticsTime(Date statisticsTime){
    this.statisticsTime = statisticsTime;
    }
    public Date getStatisticsTime(){
    return this.statisticsTime;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setSourceSystem(String sourceSystem){
    this.sourceSystem = sourceSystem;
    }
    public String getSourceSystem(){
    return this.sourceSystem;
    }
    public void setOrderType(String orderType){
    this.orderType = orderType;
    }
    public String getOrderType(){
    return this.orderType;
    }
    public void setDocumentNo(String documentNo){
    this.documentNo = documentNo;
    }
    public String getDocumentNo(){
    return this.documentNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setRelevanceNo(String relevanceNo){
    this.relevanceNo = relevanceNo;
    }
    public String getRelevanceNo(){
    return this.relevanceNo;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }

    public String getCargoName() {
        return this.cargoName;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatch() {
        return this.batch;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getLogicWarehouseName() {
        return logicWarehouseName;
    }

    public void setLogicWarehouseName(String logicWarehouseName) {
        this.logicWarehouseName = logicWarehouseName;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }
    public Date getProduceTime(){
    return this.produceTime;
    }
    public void setExpireTime(Date expireTime){
    this.expireTime = expireTime;
    }
    public Date getExpireTime(){
    return this.expireTime;
    }
    public void setNoticeCreateTime(Date noticeCreateTime){
    this.noticeCreateTime = noticeCreateTime;
    }
    public Date getNoticeCreateTime(){
    return this.noticeCreateTime;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
}
