package com.dtyunxi.tcbj.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>Tile 快递费报表查询dto</p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
public class ExpressCostReportQueryDto implements Serializable {

    /**
     *  单据类型
     */
    @ApiModelProperty(name = "billType", value = "单据类型")
    private Integer billType;
    /**
     *  记账月份
     */
    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;

    /**
     *  出库日期开始时间
     */
    @ApiModelProperty(name = "startTime", value = "出库日期开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "出库日期结束时间")
    private String endTime;


    @ApiModelProperty(name = "billNo", value = "单号")
    private String billNo;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;

    private List<String> warehouseCodeList;

    @ApiModelProperty(name = "freightOrg", value = "费用归属名称")
    private String freightOrg;

    @ApiModelProperty(name = "freightOrgCode", value = "费用归属编码")
    private String freightOrgCode;

    @ApiModelProperty(name = "freightOrgList", value = "费用归属名称集合")
    private List<String> freightOrgList;

    @ApiModelProperty(name = "freightOrgCodeList", value = "费用归属编码集合")
    private List<String> freightOrgCodeList;

    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;

    @ApiModelProperty(name = "logisticCodeList", value = "物流公司编码集合" ,hidden = true)
    private List<String> logisticCodeList;

    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private Integer chargeMode;

    /**
     *  快递单号
     */
    @ApiModelProperty(name = "expressNo", value = "快递单号")
    private String expressNo;

    /**
     *  省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
     *  城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
     *  区/县
     */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;

    @ApiModelProperty(name = "weightRange", value = "重量范围")
    private String weightRange;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页大小")
    private Integer pageSize;

    @ApiModelProperty(name = "abnormal", value = "异常标识0正常 1异常")
    private Integer abnormal;

    @ApiModelProperty(name = "shopName", value = "店铺")
    private String shopName;

    @ApiModelProperty(name = "weightDifference", value = "重量差异（快递回传重量-ocs重量）")
    private BigDecimal weightDifference;

    @ApiModelProperty(name = "ifRepeat", value = "是否重复，1是 0否")
    private Integer ifRepeat;

    @ApiModelProperty(name = "masterOrder", value = "是否总单，1是 0否")
    private Integer masterOrder;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;

    @ApiModelProperty(name = "costTypeList", value = "计费类型集合")
    private List<String> costTypeList;

    @ApiModelProperty(name = "placedFlag", value = "是否归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

}
