package com.dtyunxi.tcbj.api.dto.response;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.tcbj.api.dto.MonitorDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 监控API响应Dto
 */
@Data
public class MonitorApiResponseDto<D> {

    @ApiModelProperty(name = "apiName", value = "Api名称")
    private String apiName;

    @ApiModelProperty(name = "apiCode", value = "Api编号")
    private String apiCode;

    @ApiModelProperty(name = "failCount", value = "异常数量")
    private Long failCount;

    @ApiModelProperty(name = "logDataList", value = "日志弹窗内容列表")
    private List<PcpOpenapiLogRespDto> logDataList;

    @ApiModelProperty(name = "dataList", value = "普通弹窗列表内容")
    private List<String> dataList;

    @ApiModelProperty(name = "dtoList", value = "对象数据列表")
    private List<D> dtoList;

    @ApiModelProperty(name = "jumpType", value = "跳转类型，1：日志弹窗，2：普通弹窗")
    private Integer jumpType = 1;
}
