package com.dtyunxi.tcbj.api.dto.request;


import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * LogicalInventoryListPageParams
 */
@Data
@ApiModel(value = "LogicalInventoryListPageParams", description = "请求类")
public class LogicalInventoryListPageParams {

    @ApiModelProperty(name = "goodsLongCode", value = "商品长编码")
    @JsonProperty("goodsLongCode")
    private String goodsLongCode;


    @ApiModelProperty(name = "goodsName", value = "商品名称")
    @JsonProperty("goodsName")
    private String goodsName;


    @ApiModelProperty(name = "batchNo", value = "批次号")
    @JsonProperty("batchNo")
    private String batchNo;


    @ApiModelProperty(name = "isExpire", value = "是否过期")
    @JsonProperty("isExpire")
    private String isExpire;


    @ApiModelProperty(name = "logicalWarehouseCode", value = "逻辑仓编码")
    @JsonProperty("logicalWarehouseCode")
    private String logicalWarehouseCode;

    @ApiModelProperty(
            name = "channelIds",
            value = "渠道编码"
    )
    private List<Long> channelIds;


    @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
    @JsonProperty("logicalWarehouseName")
    private String logicalWarehouseName;


    @ApiModelProperty(name = "expireDateStart", value = "开始到期日期")
    @JsonProperty("expireDateStart")
    private String expireDateStart;


    @ApiModelProperty(name = "expireDateEnd", value = "截止到期日期")
    @JsonProperty("expireDateEnd")
    private String expireDateEnd;


    @ApiModelProperty(name = "isExceedZero", value = "实际库存>0")
    @JsonProperty("isExceedZero")
    private String isExceedZero;


    @ApiModelProperty(name = "logicalWarehouseAttr", value = "逻辑仓属性")
    @JsonProperty("logicalWarehouseAttr")
    private String logicalWarehouseAttr;

    @ApiModelProperty(name = "logicalWarehouseAttrCHN", value = "逻辑仓属性(中文)")
    @JsonProperty("logicalWarehouseAttrCHN")
    private String logicalWarehouseAttrCHN;


    @ApiModelProperty(name = "logicalWarehouseQuality", value = "逻辑仓品质")
    @JsonProperty("logicalWarehouseQuality")
    private String logicalWarehouseQuality;


    @ApiModelProperty(name = "ownPhysicalWarehouseId", value = "所属物理仓")
    @JsonProperty("ownPhysicalWarehouseId")
    private String ownPhysicalWarehouseId;


    @ApiModelProperty(name = "ownPhysicalWarehouseName", value = "所属物理仓")
    @JsonProperty("ownPhysicalWarehouseName")
    private String ownPhysicalWarehouseName;

    @ApiModelProperty(name = "pageSize", value = "")
    @JsonProperty("pageSize")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "pageNum", value = "")
    @JsonProperty("pageNum")
    private Integer pageNum = 1;

    /**
     * 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    @JsonProperty("warehouseClassify")
    private String warehouseClassify;

    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    @JsonProperty("subordinateLogicWarehouseId")
    private Long subordinateLogicWarehouseId;

    /**
     * 所属逻辑仓名称
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓名称")
    @JsonProperty("subordinateLogicWarehouseName")
    private String subordinateLogicWarehouseName;

    //-- 总表查询新增
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;


    @ApiModelProperty(name = "queryType", value = "默认逻辑仓, 1 逻辑仓 2 渠道仓 3 供货仓 4 物理仓")
    private Integer queryType = 1;

    @ApiModelProperty(name = "balanceStart", value = "即时库存开始范围")
    private BigDecimal balanceStart;

    @ApiModelProperty(name = "balanceEnd", value = "即时库存结束范围")
    private BigDecimal balanceEnd;

    @ApiModelProperty(name = "preemptStart", value = "预占库存开始范围")
    private BigDecimal preemptStart;
    @ApiModelProperty(name = "preemptEnd", value = "预占库存结束范围")
    private BigDecimal preemptEnd;

    @ApiModelProperty(name = "availableStart", value = "可用库存开始范围")
    private BigDecimal availableStart;
    @ApiModelProperty(name = "availableEnd", value = "可用库存开始范围")
    private BigDecimal availableEnd;
    @ApiModelProperty(name = "availableQueryType", value = "可用库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer availableQueryType;
    @ApiModelProperty(name = "preemptQueryType", value = "预占库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer preemptQueryType;
    @ApiModelProperty(name = "balanceQueryType", value = "即时库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer balanceQueryType;

    @ApiModelProperty(name = "有效期是否小于9个月", value = "0否  1是")
    private Integer validityLessThanNineMonths;

}
