package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 折扣明细
 * @since 2022-01-18 16:32
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "RebateOrderDetailRespDto", description = "折扣明细")
public class RebateOrderDetailRespDto extends ReportBaseRespDto{

    @ApiModelProperty(name = "discountTypeStr", value = "折扣类型")
    private String discountTypeStr;


    @ApiModelProperty(name = "discountAmount", value = "折扣金额")
    private BigDecimal discountAmount;

    @ApiModelProperty(name = "useDiscountAmount", value = "已使用折扣")
    private BigDecimal useDiscountAmount;

    @ApiModelProperty(name = "remainderAllowUseDiscountAmount", value = "未使用折扣")
    private BigDecimal remainderAllowUseDiscountAmount;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;

    @ApiModelProperty(name = "status",
            value = "状态(WAIT_AUDIT:待审核," +
            "AUDIT_REJECT:审核不通过," +
            "WAIT_ISSUE:待发放," +
            "ISSUED:已发放," +
            "EXPIRED:已失效)")
    private String status;

    private String statusStr;

    @ApiModelProperty(name = "orderNo", value = "关联单号")
    private String orderNo;
}
