package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;

import com.dtyunxi.tcbj.api.dto.response.ApportionOtherCostRespDto;
import com.dtyunxi.tcbj.api.dto.response.StatisticsBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 仓储账单表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储账单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IStorageChargeBillApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeBill",
    url = "${tcbj-center-report.api:}"
)
public interface IStorageChargeBillApi {

    /**
    * 新增仓储账单表
    *
    * @param addReqDto 仓储账单表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增仓储账单表", notes = "新增仓储账单表")
    RestResponse<Long> addStorageChargeBill(@RequestBody StorageChargeBillReqDto addReqDto);

    /**
    * 修改仓储账单表
    *
    * @param modifyReqDto 仓储账单表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改仓储账单表", notes = "修改仓储账单表")
    RestResponse<Void> modifyStorageChargeBill(@RequestBody StorageChargeBillReqDto modifyReqDto);

    /**
    * 删除仓储账单表
    *
    * @param ids        仓储账单表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓储账单表", notes = "删除仓储账单表")
    RestResponse<Void> removeStorageChargeBill(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
     * 分摊其他费用
     *
     * @param apportionOtherReqDto 仓储账单表请求对象
     * @return 处理结果
     */
    @PostMapping("/apportionOtherList")
    @ApiOperation(value = "分摊其他费用明细", notes = "分摊其他费用明细")
    RestResponse<List<StorageChargeBillRespDto>> apportionOtherList(@RequestBody ApportionOtherReqDto apportionOtherReqDto);

    /**
     * 分摊其他费用
     *
     * @param apportionOtherReqDto 仓储账单表请求对象
     * @return 处理结果
     */
    @PostMapping("/apportionOther")
    @ApiOperation(value = "分摊其他费用", notes = "分摊其他费用")
    RestResponse<ApportionOtherCostRespDto> apportionOther(@RequestBody ApportionOtherReqDto apportionOtherReqDto);

    /**
     * 根据合同触发账单变更
     *
     * @param updateStorageReqDto 根据合同触发账单变更
     * @return 处理结果
     */
    @PostMapping("/updateStorageBill")
    @ApiOperation(value = "根据合同触发账单变更", notes = "根据合同触发账单变更")
    RestResponse<Void> updateStorageBill(@RequestBody UpdateStorageDetailDto updateStorageReqDto);

    /**
     * 批次保存账单
     *
     * @param salveList 批次保存账单
     * @return 处理结果
     */
    @PostMapping("/batchSave")
    @ApiOperation(value = "批次保存账单", notes = "批次保存账单")
    RestResponse<Void> batchSave(@RequestBody List<StorageChargeBillReqDto> salveList);

    @PostMapping("/statisticsBillSum")
    @ApiOperation(value = "统计体积/板数占比", notes = "统计体积/板数占比")
    RestResponse<List<StatisticsBillRespDto>> statisticsBillSum(@RequestBody StatisticsBillReqDto statisticsBillReqDto);

    @PostMapping("/queryBillDto")
    @ApiOperation(value = "查询账单是否存在", notes = "批次保存账单")
    RestResponse<StorageChargeBillRespDto> queryBillDto(@RequestBody StorageChargeBillReqDto storageChargeBillReqDto);

    @PostMapping("/createInnerTradeOrderDetail")
    @ApiOperation(value = "手动生成内部交易的仓储明细", notes = "手动生成内部交易的仓储明细")
    RestResponse<Void> createInnerTradeOrderDetail(@RequestBody List<String> tradeOrderList);

    /**
     * 仓储账单更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "仓储账单更新归档标识", notes = "仓储账单更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

}
