package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"费用公共服务"})
@FeignClient(
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/fee/common",
        url = "${tcbj.center.report.api:}"
)
public interface IFeeCommonApi {

    @PostMapping("/generateInsurance")
    @ApiOperation(value = "根据每日发货报表生成费用明细", notes = "根据每日发货报表生成费用明细")
    RestResponse<String> generateInsurance(@RequestBody FeeGenerateReqDto reqDto);

}
