package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BatchAdjustmentOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.BatchAdjustmentOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
 * 批次调整单服务接口
 *
 * @author yuangui
 * @since 2022-04-26
 */
@Api(tags = {"批次调整单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/batchAdjustmentOrder", url = "${tcbj.center.report.api:}")
public interface IBatchAdjustmentOrderQueryApi {

    /**
     * 根据id查询批次调整单
     *
     * @param id 批次调整单id
     * @return 批次调整单数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询批次调整单", notes = "根据id查询批次调整单")
    RestResponse<BatchAdjustmentOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 批次调整单分页数据
     *
     * @param filter 批次调整单查询条件
     * @return 批次调整单分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "批次调整单分页数据", notes = "根据filter查询条件查询批次调整单数据，filter=BatchAdjustmentOrderReqDto")
    RestResponse<PageInfo<BatchAdjustmentOrderRespDto>> queryByPage(@RequestBody BatchAdjustmentOrderReqDto filter);

}
