package com.dtyunxi.tcbj.api.dto.request;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author minyue
 * @description: 活动明细
 * @since 2022-01-19 16:39
 */
@Data
@ApiModel(value = "OrderActivityDetailReqDto", description = "活动明细")
public class OrderActivityDetailReqDto extends PageInfo<OrderActivityDetailReqDto> {

    @ApiModelProperty(name = "activityCode", value = "活动编码")
    private String activityCode;

    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "shopId", value = "所属店铺")
    private String shopId;

    @ApiModelProperty(name = "organizationIds", value = "组织")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "status", value = "活动状态")
    private String status;

    @ApiModelProperty(name = "customerName", value = "参与客户")
    private String customerName;

    @ApiModelProperty(name = "orderNo", value = "关联订单")
    private String orderNo;

//    @ApiModelProperty(name = "pageNum", value = "页数")
//    private Integer pageNum = 1;
//
//    @ApiModelProperty(name = "pageSize", value = "每页条数")
//    private Integer pageSize = 10;
}
