package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
/**
 * 采购、采购退货单订单状态数量统计实体
 */
@ApiModel(value = "orderStatusCountRespDto", description = "采购、采购退货单订单状态数量统计")
public class InPlannedOrderStatusCountRespDto {
    /**
     * 全部数量
     */
    @ApiModelProperty(name = "total", value = "全部数量")
    private BigDecimal total;
    /**
     * 待提交数量
     */
    @ApiModelProperty(name = "waitSubmit", value = "待提交数量")
    private BigDecimal waitSubmit;
    /**
     * 待审核数量
     */
    @ApiModelProperty(name = "waitAudit", value = "待审核数量")
    private BigDecimal waitAudit;
    /**
     * 待入库数量
     */
    @ApiModelProperty(name = "waitIn", value = "待入库数量")
    private BigDecimal waitIn;
    /**
     * 部分入库数量
     */
    @ApiModelProperty(name = "portionIn", value = "部分入库数量")
    private BigDecimal portionIn;
    /**
     * 已完成数量
     */
    @ApiModelProperty(name = "completed", value = "已完成数量")
    private BigDecimal completed;
    /**
     * 审核不通过数量
     */
    @ApiModelProperty(name = "auditFailed", value = "审核不通过数量")
    private BigDecimal auditFailed;
    /**
     * 已完结数量
     */
    @ApiModelProperty(name = "finish", value = "已完结数量")
    private BigDecimal finish;
    /**
     * 挂起数量
     */
    @ApiModelProperty(name = "hangUp", value = "挂起数量")
    private BigDecimal hangUp;
    /**
     * 已关闭数量
     */
    @ApiModelProperty(name = "cancel", value = "已关闭数量")
    private BigDecimal cancel;

    /**
     * 待出库数量
     */
    @ApiModelProperty(name = "waitOut", value = "待出库数量")
    private BigDecimal waitOut;
    /**
     * 部分出库数量
     */
    @ApiModelProperty(name = "portionOut", value = "部分出库数量")
    private BigDecimal portionOut;

    /**
     * 待一级审核数量
     */
    @ApiModelProperty(name = "waitLevelOneAudit", value = "待一级审核数量")
    private BigDecimal waitLevelOneAudit;

    /**
     * 待二级审核数量
     */
    @ApiModelProperty(name = "waitLevelTwoAudit", value = "待二级审核数量")
    private BigDecimal waitLevelTwoAudit;

    public BigDecimal getTotal() {
        return total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public BigDecimal getWaitSubmit() {
        return waitSubmit;
    }

    public void setWaitSubmit(BigDecimal waitSubmit) {
        this.waitSubmit = waitSubmit;
    }

    public BigDecimal getWaitAudit() {
        return waitAudit;
    }

    public void setWaitAudit(BigDecimal waitAudit) {
        this.waitAudit = waitAudit;
    }

    public BigDecimal getWaitIn() {
        return waitIn;
    }

    public void setWaitIn(BigDecimal waitIn) {
        this.waitIn = waitIn;
    }

    public BigDecimal getPortionIn() {
        return portionIn;
    }

    public void setPortionIn(BigDecimal portionIn) {
        this.portionIn = portionIn;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }

    public BigDecimal getAuditFailed() {
        return auditFailed;
    }

    public void setAuditFailed(BigDecimal auditFailed) {
        this.auditFailed = auditFailed;
    }

    public BigDecimal getFinish() {
        return finish;
    }

    public void setFinish(BigDecimal finish) {
        this.finish = finish;
    }

    public BigDecimal getHangUp() {
        return hangUp;
    }

    public void setHangUp(BigDecimal hangUp) {
        this.hangUp = hangUp;
    }

    public BigDecimal getCancel() {
        return cancel;
    }

    public void setCancel(BigDecimal cancel) {
        this.cancel = cancel;
    }

    public BigDecimal getWaitOut() {
        return waitOut;
    }

    public void setWaitOut(BigDecimal waitOut) {
        this.waitOut = waitOut;
    }

    public BigDecimal getPortionOut() {
        return portionOut;
    }

    public void setPortionOut(BigDecimal portionOut) {
        this.portionOut = portionOut;
    }

    public BigDecimal getWaitLevelOneAudit() {
        return waitLevelOneAudit;
    }

    public void setWaitLevelOneAudit(BigDecimal waitLevelOneAudit) {
        this.waitLevelOneAudit = waitLevelOneAudit;
    }

    public BigDecimal getWaitLevelTwoAudit() {
        return waitLevelTwoAudit;
    }

    public void setWaitLevelTwoAudit(BigDecimal waitLevelTwoAudit) {
        this.waitLevelTwoAudit = waitLevelTwoAudit;
    }
}
