package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
* 物流运费明细记录表Eo对象
*
* @author author
* @since 2022-07-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FinLogisticDetailRespDto", description = "物流运费明细记录表Eo对象")
public class FinLogisticDetailRespDto extends BaseRespDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  记账日期
     */
    @ApiModelProperty(name = "bookkeepingDate", value = "记账日期")
    private String bookkeepingDate;
    /**
     *  开单日期
     */
    @ApiModelProperty(name = "billingDate", value = "开单日期")
    private String billingDate;
    /**
     * eas单号
     */
    @ApiModelProperty(name = "easNo", value = "eas单号")
    private String easNo;
    /**
    *  物流费合计id
    */
    @ApiModelProperty(name = "reportId", value = "物流费合计id")
    private String reportId;
    /**
     *  类型
     */
    @ApiModelProperty(name = "type", value = "类型")
    private String type;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     * 合同基准油价
     */
    @ApiModelProperty(name = "contractOilPrice", value = "合同基准油价")
    private BigDecimal contractOilPrice;
    /**
     * 油价幅度
     */
    @ApiModelProperty(name = "rangeOilPrice", value = "油价幅度")
    private String rangeOilPrice;
    /**
     * 联动油价
     */
    @ApiModelProperty(name = "linkOilPrice", value = "联动油价")
    private BigDecimal linkOilPrice;
    /**
     * 运费调整幅度
     */
    @ApiModelProperty(name = "adjustOilPrice", value = "运费调整幅度")
    private BigDecimal adjustOilPrice;
    /**
     *  出库时间
     */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;

    /**
     *  出库通知单号
     */
    @ApiModelProperty(name = "outNoticeCode", value = "出库通知单号")
    private String outNoticeCode;
    /**
     *  出库结果单号
     */
    @ApiModelProperty(name = "outResultCode", value = "出库结果单号")
    private String outResultCode;

    /**
     *  出库单号
     */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
     *  wms出库单号
     */
    @ApiModelProperty(name = "wmsOutboundCode", value = "wms出库单号")
    private String wmsOutboundCode;
    /**
     *  wms合单号
     */
    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;
    /**
     *  关联业务单号
     */
    @ApiModelProperty(name = "businessCode", value = "关联业务单号")
    private String businessCode;
    /**
     *  仓库
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库")
    private String warehouseName;
    /**
     *  物流公司
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     *  承运单号
     */
    @ApiModelProperty(name = "transportNo", value = "承运单号")
    private String transportNo;
    /**
     *  托运单号
     */
    @ApiModelProperty(name = "transportCode", value = "托运单号")
    private String transportCode;
    /**
     *  瓶数
     */
    @ApiModelProperty(name = "bottle", value = "瓶数")
    private BigDecimal bottle;
    /**
     *  箱数
     */
    @ApiModelProperty(name = "box", value = "箱数")
    private BigDecimal box;
    /**
     *  体积（m^3）
     */
    @ApiModelProperty(name = "volume", value = "体积（m^3）")
    private BigDecimal volume;
    /**
     *  重量（KG）
     */
    @ApiModelProperty(name = "weight", value = "重量（KG）")
    private BigDecimal weight;
    /**
     *  累计箱数
     */
    @ApiModelProperty(name = "totalBox", value = "累计箱数")
    private BigDecimal totalBox;
    /**
     *  累计体积（m^3）
     */
    @ApiModelProperty(name = "totalVolume", value = "累计体积（m^3）")
    private BigDecimal totalVolume;
    /**
     *  累计重量（KG）
     */
    @ApiModelProperty(name = "totalWeight", value = "累计重量（KG）")
    private BigDecimal totalWeight;
    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;
    /**
     *  运费单价
     */
    @ApiModelProperty(name = "transportPrice", value = "运费单价")
    private BigDecimal transportPrice;
    /**
     *  运费金额
     */
    @ApiModelProperty(name = "transportAmount", value = "运费金额")
    private BigDecimal transportAmount;
    /**
     *  最低费用
     */
    @ApiModelProperty(name = "minCharge", value = "最低费用")
    private BigDecimal minCharge;
    /**
     *  送货费
     */
    @ApiModelProperty(name = "deliveryAmount", value = "送货费")
    private BigDecimal deliveryAmount;
    /**
     *  卸货费
     */
    @ApiModelProperty(name = "unloadAmount", value = "卸货费")
    private BigDecimal unloadAmount;
    /**
     *  油价联动
     */
    @ApiModelProperty(name = "oilPrice", value = "油价联动")
    private BigDecimal oilPrice;
    /**
     * 油价总金额
     */
    @ApiModelProperty(name = "oilTotalPrice", value = "油价总金额")
    private BigDecimal oilTotalPrice;
    /**
     *  特殊费用类型
     */
    @ApiModelProperty(name = "specialType", value = "特殊费用类型")
    private String specialType;
    /**
     *  特殊费用
     */
    @ApiModelProperty(name = "specialAmount", value = "特殊费用")
    private BigDecimal specialAmount;
    /**
     *  运费合计
     */
    @ApiModelProperty(name = "totalTransportAmount", value = "运费合计")
    private BigDecimal totalTransportAmount;
    /**
     *  分摊费用
     */
    @ApiModelProperty(name = "shareAmount", value = "分摊费用")
    private BigDecimal shareAmount;
    /**
     *  调出仓库
     */
    @ApiModelProperty(name = "warehouseOut", value = "调出仓库")
    private String warehouseOut;
    /**
     *  调出组织
     */
    @ApiModelProperty(name = "organizationOut", value = "调出组织")
    private String organizationOut;
    /**
     *  调入仓库
     */
    @ApiModelProperty(name = "warehouseEnter", value = "调入仓库")
    private String warehouseEnter;
    /**
     *  调入组织
     */
    @ApiModelProperty(name = "organizationEnter", value = "调入组织")
    private String organizationEnter;
    /**
     *  费用归属
     */
    @ApiModelProperty(name = "amountAttribution", value = "费用归属")
    private String amountAttribution;
    /**
     *  收货人
     */
    @ApiModelProperty(name = "harvestPeople", value = "收货人")
    private String harvestPeople;
    /**
     *  省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    @ApiModelProperty(name = "provinceCode", value = "省份Code")
    private String provinceCode;
    /**
     *  城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
     * 城市Code
     */
    @ApiModelProperty(name = "cityCode", value = "城市Code")
    private String cityCode;
    /**
     * 城市级别
     */
    @ApiModelProperty(name = "cityLevel", value = "城市级别")
    private String cityLevel;
    /**
     * 区
     */
    @ApiModelProperty(name = "area", value = "区域")
    private String area;
    @ApiModelProperty(name = "areaCode", value = "区域Code")
    private String areaCode;
    /**
     *  客户收货地址
     */
    @ApiModelProperty(name = "harvestAddress", value = "客户收货地址")
    private String harvestAddress;
    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 经纬度
     */
    @ApiModelProperty(name = "lngLat", value = "经纬度,以,分割")
    private String lngLat;
    /**
     *  状态（0=正常 1=异常）
     */
    @ApiModelProperty(name = "status", value = "状态（0=正常 1=异常）")
    private Integer status;
    /**
     *  异常原因
     */
    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;
    /**
     *  备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "mergeCode", value = "合单编码")
    private String mergeCode;

    @ApiModelProperty(name = "calUnitName", value = "精准计费方式")
    private String calUnitName;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    private List<String> reportIds;

    @ApiModelProperty(name = "masterDetailRespDto", value = "合单主单")
    private FinLogisticDetailRespDto masterDetailRespDto;

    @ApiModelProperty(name = "costBelongOrgCode", value = "费用归属组织CODE")
    private String costBelongOrgCode;

    @ApiModelProperty(name = "costBelongOrgName", value = "费用归属组织名称")
    private String costBelongOrgName;

    @ApiModelProperty(name = "quantity", value = "出库数量")
    private BigDecimal quantity;

    public String getUniqueKey(){
        String day = "";
        if (this.getOutboundTime()!=null){
            day = DateUtil.getDateFormat(this.getOutboundTime(), DateUtil.YMD_DATA);
        }
        return String.format("%s,%s,%s,%s",day,this.getWarehouseName(),this.getLogisticCompany(),this.getTransportType());
    }


}
