package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionSubmitDataReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 质检数据服务接口
 *
 * @author 天泽
 * @since 2022-08-09
 */
@Api(tags = {"质检数据服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IQualityInspectionDataApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/quality/inspection",
        url = "${tcbj.center.report.api:}"
)
public interface IQualityInspectionDataApi {

    /**
     * 新增质检数据
     *
     * @param addReqDto 质检数据请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增质检数据", notes = "新增质检数据")
    RestResponse<Long> addQualityInspectionData(@RequestBody QualityInspectionDataReqDto addReqDto);

    /**
     * 修改质检数据
     *
     * @param modifyReqDto 质检数据请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改质检数据", notes = "修改质检数据")
    RestResponse<Void> modifyQualityInspectionData(@RequestBody QualityInspectionDataReqDto modifyReqDto);

    /**
     * 删除质检数据
     *
     * @param ids        质检数据删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除质检数据", notes = "删除质检数据")
    RestResponse<Void> removeQualityInspectionData(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 批量保存
     *
     * @param list 质检数据请求对象
     * @return 处理结果
     */
    @PostMapping("batchSave")
    @ApiOperation(value = "批量保存", notes = "批量保存")
    RestResponse<Void> batchSave(@RequestBody List<QualityInspectionDataReqDto> list);

    @PostMapping("/importBatchSave")
    @ApiOperation(value = "批量保存,导入专用", notes = "批量保存")
    RestResponse<Void> importBatchSave(@RequestBody List<QualityInspectionDataReqDto> list);


    /**
     * 批量更新
     *
     * @param list 质检数据请求对象
     * @return 处理结果
     */
    @PostMapping("batchUpdate")
    @ApiOperation(value = "批量更新", notes = "批量更新")
    RestResponse<Void> batchUpdate(@RequestBody List<QualityInspectionDataReqDto> list);

    @PostMapping("batchSubmitDataCU")
    @ApiOperation(value = "质检提单数据新增或编辑", notes = "质检提单数据新增或编辑")
    RestResponse<Void> batchSubmitDataCU(@RequestBody List<QualityInspectionSubmitDataReqDto> list);

    @GetMapping("queryListByNotAcceptDate")
    @ApiOperation(value = "获取无受理时间的质检提单数据", notes = "获取无受理时间的质检提单数据")
    RestResponse<List<QualityInspectionSubmitDataReqDto>> queryListByNotAcceptDate();

}
