package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.AdjustStorageApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeDetailRespDto;
import com.dtyunxi.tcbj.api.vo.ImportStorageChargeDetailChangeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 仓储账单明细表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储账单明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IStorageChargeDetailApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeDetail",
    url = "${tcbj-center-report.api:}"
)
public interface IStorageChargeDetailApi {

    /**
    * 新增仓储账单明细表
    *
    * @param addReqDto 仓储账单明细表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增仓储账单明细表", notes = "新增仓储账单明细表")
    RestResponse<Long> addStorageChargeDetail(@RequestBody StorageChargeDetailReqDto addReqDto);

    /**
    * 修改仓储账单明细表
    *
    * @param modifyReqDto 仓储账单明细表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改仓储账单明细表", notes = "修改仓储账单明细表")
    RestResponse<Void> modifyStorageChargeDetail(@RequestBody StorageChargeDetailReqDto modifyReqDto);

    /**
    * 删除仓储账单明细表
    *
    * @param ids        仓储账单明细表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓储账单明细表", notes = "删除仓储账单明细表")
    RestResponse<Void> removeStorageChargeDetail(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
     * 导入变更仓储明细
     * @param importDto
     * @return 处理结果
     */
    @PostMapping("/import")
    @ApiOperation(value = "导入变更仓储明细", notes = "导入变更仓储明细")
    RestResponse<BizImportRespDto> importStorageChargeDetail(@RequestBody BizImportDataReqDto<ImportStorageChargeDetailChangeVo> importDto);

    /**
     * 调整仓储明细
     * @param detailReqDto
     * @return
     */
    @PostMapping("/adjustStorageApportionDetail")
    @ApiOperation(value = "调整仓储明细", notes = "调整仓储明细")
    RestResponse<Void> adjustStorageApportionDetail(@RequestBody AdjustStorageApportionDetailReqDto detailReqDto);
}
