package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 业务员表Eo对象
*
* @author yuangui
* @since 2022-03-19
*/
@ApiModel(value = "CustomerSalesmanReqDto", description = "业务员表Eo对象")
public class PCPCustomerSalesmanReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  业务员编码，系统生成
    */
    @ApiModelProperty(name = "code", value = "业务员编码，系统生成")
    private String code;
    /**
    *  业务员名字
    */
    @ApiModelProperty(name = "name", value = "业务员名字")
    private String name;
    /**
    *  性别，0-未知，1-女，2-男
    */
    @ApiModelProperty(name = "sex", value = "性别，0-未知，1-女，2-男")
    private Integer sex;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgInfoId", value = "组织id")
    private Long orgInfoId;
    /**
    *  用户id
    */
    @ApiModelProperty(name = "userId", value = "用户id")
    private Long userId;
    /**
    *  状态，0-禁用，1-启用
    */
    @ApiModelProperty(name = "status", value = "状态，0-禁用，1-启用")
    private Integer status;
    /**
    *  职位
    */
    @ApiModelProperty(name = "position", value = "职位")
    private String position;
    /**
    *  部门
    */
    @ApiModelProperty(name = "department", value = "部门")
    private String department;
    /**
    *  手机号码
    */
    @ApiModelProperty(name = "mobileNumber", value = "手机号码")
    private String mobileNumber;
    /**
    *  员工编号，唯一
    */
    @ApiModelProperty(name = "jobNumber", value = "员工编号，唯一")
    private String jobNumber;
    /**
    *  电子邮箱
    */
    @ApiModelProperty(name = "email", value = "电子邮箱")
    private String email;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remarks", value = "备注")
    private String remarks;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setSex(Integer sex){
    this.sex = sex;
    }
    public Integer getSex(){
    return this.sex;
    }
    public void setOrgInfoId(Long orgInfoId){
    this.orgInfoId = orgInfoId;
    }
    public Long getOrgInfoId(){
    return this.orgInfoId;
    }
    public void setUserId(Long userId){
    this.userId = userId;
    }
    public Long getUserId(){
    return this.userId;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setPosition(String position){
    this.position = position;
    }
    public String getPosition(){
    return this.position;
    }
    public void setDepartment(String department){
    this.department = department;
    }
    public String getDepartment(){
    return this.department;
    }
    public void setMobileNumber(String mobileNumber){
    this.mobileNumber = mobileNumber;
    }
    public String getMobileNumber(){
    return this.mobileNumber;
    }
    public void setJobNumber(String jobNumber){
    this.jobNumber = jobNumber;
    }
    public String getJobNumber(){
    return this.jobNumber;
    }
    public void setEmail(String email){
    this.email = email;
    }
    public String getEmail(){
    return this.email;
    }
    public void setRemarks(String remarks){
    this.remarks = remarks;
    }
    public String getRemarks(){
    return this.remarks;
    }
}
