/**
 * @(#) SecurityCodeReportVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;

/**
 * SecurityCodeReportVO
 */
@Data
@ApiModel(value = "SecurityCodeReportRespDto", description = "")
public class SecurityCodeReportRespDto   {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime = null;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime = null;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson = null;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson = null;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;
  
  
  @ApiModelProperty(name="statisticalDate", value = "统计日期")
  @JsonProperty("statisticalDate")
  private String statisticalDate;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="documentNo", value = "出库结果单号")
  @JsonProperty("documentNo")
  private String documentNo;
  
  
  @ApiModelProperty(name="cargoRightName", value = "库存组织")
  @JsonProperty("cargoRightName")
  private String cargoRightName;
  
  
  @ApiModelProperty(name="goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;
  
  
  @ApiModelProperty(name="goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;
  
  
  @ApiModelProperty(name="batch", value = "批次")
  @JsonProperty("batch")
  private String batch;
  
  
  @ApiModelProperty(name="logicalWarehouseCode", value = "逻辑仓编码")
  @JsonProperty("logicalWarehouseCode")
  private String logicalWarehouseCode;
  
  
  @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;
  
  
  @ApiModelProperty(name="strandCode", value = "串码")
  @JsonProperty("strandCode")
  private String strandCode;
  
  
  @ApiModelProperty(name="securityCode", value = "防伪码")
  @JsonProperty("securityCode")
  private String securityCode;
  
  
  @Valid 
  @ApiModelProperty(name="issuedQuantity", value = "数量")
  @JsonProperty("issuedQuantity")
  private BigDecimal issuedQuantity;
  
  
  @ApiModelProperty(name="deliveryTime", value = "发货日期")
  @JsonProperty("deliveryTime")
  private String deliveryTime;

  @ApiModelProperty(name="easSaleOrderNo", value = "eas单号")
  @JsonProperty("easSaleOrderNo")
  private String easSaleOrderNo;
  
}

