package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 批次调整单Eo对象
*
* @author yuangui
* @since 2022-04-26
*/
@ApiModel(value = "BatchAdjustmentOrderReqDto", description = "批次调整单Eo对象")
public class BatchAdjustmentOrderReqDto extends BaseDto {
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  批次调整单号
    */
    @ApiModelProperty(name = "orderNo", value = "批次调整单号")
    private String orderNo;
    /**
    *  业务类型：general_adjustment:普通调整
    */
    @ApiModelProperty(name = "businessType", value = "业务类型：general_adjustment:普通调整")
    private String businessType;
    /**
    *  单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过")
    private String orderStatus;
    /**
    *  是否同步wms：1是，0否
    */
    @ApiModelProperty(name = "synchronousWms", value = "是否同步wms：1是，0否")
    private Integer synchronousWms;
    /**
    *  逻辑仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "逻辑仓库ID")
    private Long warehouseId;
    /**
    *  逻辑仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;
    /**
    *  逻辑仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "逻辑仓库名称")
    private String warehouseName;
    /**
    *  总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(
            name = "createBeginTime",
            value = "创建开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(
            name = "createEndTime",
            value = "创建结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createEndTime;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrderNo(String orderNo){
    this.orderNo = orderNo;
    }
    public String getOrderNo(){
    return this.orderNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setSynchronousWms(Integer synchronousWms){
    this.synchronousWms = synchronousWms;
    }
    public Integer getSynchronousWms(){
    return this.synchronousWms;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setTotalQuantity(BigDecimal totalQuantity){
    this.totalQuantity = totalQuantity;
    }
    public BigDecimal getTotalQuantity(){
    return this.totalQuantity;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }

    public Date getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(Date createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public Date getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(Date createEndTime) {
        this.createEndTime = createEndTime;
    }
}
