package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 出库/入库通知单wms状态Eo对象
*
* @author 紫霄
* @since 2023-07-24
*/
@ApiModel(value = "CsNoticeWmsStatusReqDto", description = "出库/入库通知单wms状态Eo对象")
@Data
public class CsNoticeWmsStatusReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  wms唯一编码
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms唯一编码")
    private String wmsOrderNo;
    /**
    *  通知单号
    */
    @ApiModelProperty(name = "documentNo", value = "通知单号")
    private String documentNo;
    /**
    *  单据类型 out:出库；in:入库
    */
    @ApiModelProperty(name = "type", value = "单据类型 out:出库；in:入库")
    private String type;
    /**
    *  单据状态（wms操作动作） receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；
    */
    @ApiModelProperty(name = "orderStatusList", value = "单据状态（wms操作动作） receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；")
    private List<String> orderStatusList;

    @ApiModelProperty(name = "businessTypeList", value = "业务类型")
    private List<String> businessTypeList;

    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓")
    private List<String> physicsWarehouseCodeList;
    /**
    *  操作人
    */
    @ApiModelProperty(name = "optPerson", value = "操作人")
    private String optPerson;


    @ApiModelProperty(name = "optTime", value = "操作时间开始")
    private String optTimeStart;

    @ApiModelProperty(name = "optTime", value = "操作时间结束")
    private String optTimeEnd;
    /**
    *  操作内容
    */
    @ApiModelProperty(name = "optContent", value = "操作内容")
    private String optContent;

    private Integer pageSize;
    private Integer pageNum;


}
