package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPageQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShInventoryPreemptionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* 渠道仓库存表服务接口
*
* @author wude
* @since 2022-03-09
*/
@Api(tags = {"渠道仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/channelInventory", url = "${tcbj.center.report.api:}")
public interface IChannelInventoryQueryApi {

    @PostMapping("/queryPreemptionPage")
    @ApiOperation(value = "渠道仓库存表分页数据", notes = "根据filter查询条件查询渠道仓库存表数据，filter=ChannelInventoryReqDto")
    RestResponse<PageInfo<ShInventoryPreemptionRespDto>> queryPreemptionPage(@RequestBody ShInventoryPageQueryReqDto filter);

    @PostMapping("/queryRelVirtualInventory/{channelWarehouseCode}/{cargoCode}")
    @ApiOperation(value = "查询关联供货仓库存", notes = "查询关联供货仓库存")
    RestResponse<List<RelShareInventoryRespDto>> queryRelVirtualInventory(@PathVariable("channelWarehouseCode") String channelWarehouseCode,
                                                            @PathVariable("cargoCode") String cargoCode);

    @PostMapping("/queryLogicInventory")
    @ApiOperation(value = "根据商品查询逻辑仓", notes = "根据商品查询逻辑仓")
    RestResponse<PageInfo<LogicInventoryRespDto>> queryLogicInventory(@RequestBody LogicInventoryReqDto logicInventoryReqDto);

    @PostMapping("/queryLogicBatchInventory/{logicWarehouseCode}/{cargoCode}")
    @ApiOperation(value = "根据商品长编码和逻辑仓编码查询不同批次库存", notes = "根据商品长编码和逻辑仓编码查询不同批次库存")
    RestResponse<List<RelShareInventoryRespDto>> queryLogicBatchInventory(@PathVariable("logicWarehouseCode") String logicWarehouseCode,
                                                                       @PathVariable("cargoCode") String cargoCode);

}
