package com.dtyunxi.tcbj.api.dto.response.es;

import cn.hutool.core.util.NumberUtil;
import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售订单明细VO类
 *
 */
@Data
@ApiModel(value = "SaleOrderItemRespEsVo", description = "销售订单明细VO类")
public class SaleOrderItemRespEsVo extends BaseRespDto implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 平台订单ID
     */
    @ApiModelProperty(name = "platformOrderId", value = "平台订单ID")
    private Long platformOrderId;
    /**
     * 平台订单号
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;
    /**
     * 平台父订单号
     */
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;
    /**
     * 主订单
     */
    @ApiModelProperty(name = "mainOrderNo", value = "主订单")
    private String mainOrderNo;
    /**
     * 订单类型 0-经销订单 1-积分订单 2-普通订单
     * 订单类型 订单类型 common_order: ''普通订单'',agency_order: ''经销订单'',shoppe_order: ''专柜订单'',integral_order: ''积分订单'',replenishment_order: ''货补订单'',activity_order: ''活动订单'',customer_refunding_order: ''消费者退换'',compensation_order: ''索赔订单'',quality_refunding_order: ''质量退换货'',replenish_order: ''少货补发'',
     */
    @ApiModelProperty(name = "orderType", value = "订单类型 0-经销订单 1-积分订单 2-普通订单")
    private String orderType;
    /**
     * 订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分
     */
    @ApiModelProperty(name = "orderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private String orderStatus;
    /**
     * 内部订单号
     */
    @ApiModelProperty(name = "saleOrderNo", value = "内部订单号")
    private String saleOrderNo;
    /**
     * 销售订单父订单
     */
    @ApiModelProperty(name = "parentOrderNo", value = "销售订单父订单")
    private String parentOrderNo;
    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     * 订单来源：0：线下 1: 线上
     */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
     * 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
     */
    @ApiModelProperty(name = "orderSource", value = "订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
     * 销售订单创建时间
     */
    @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
    private Date saleCreateTime;
    /**
     * 商品总数量
     */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private BigDecimal goodsTotalNum;
    /**
     * 原订单号（订单被拆分前对应的订单号）
     */
    @ApiModelProperty(name = "originalOrder", value = "原订单号（订单被拆分前对应的订单号）")
    private String originalOrder;
    /**
     * 订单级别：0-原 1-主 2-子
     */
    @ApiModelProperty(name = "orderLevel", value = "订单级别：0-原 1-主 2-子")
    private Integer orderLevel;
    /**
     * 订单状态流转
     */
    @ApiModelProperty(name = "orderSteps", value = "订单状态流转")
    private String orderSteps;

    @ApiModelProperty(name = "orderId", value = "订单id")
    private Long orderId;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     * 商品数量
     */
    @ApiModelProperty(name = "itemNum", value = "商品数量")
    private BigDecimal itemNum;

    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * sku编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    /**
     * 规格名称
     */
    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;
    /**
     * 批次号
     */
    @ApiModelProperty(name = "batchNo", value = "批次号")
    private String batchNo;
    /**
     * 体积 单位(m³)
     */
    @ApiModelProperty(name = "volume", value = "体积 单位(m³)")
    private BigDecimal volume;
    /**
     * 总体积 单位(m³)
     */
    @ApiModelProperty(name = "volumeSum", value = "总体积 单位(m³)")
    private BigDecimal volumeSum;
    /**
     * 是否赠品：0否，1是
     */
    @ApiModelProperty(name = "gift", value = "是否赠品：0否，1是")
    private Integer gift;
    /**
     * 逻辑仓主键ID
     */
    @ApiModelProperty(name = "logicalWarehouseId", value = "逻辑仓主键ID")
    private Long logicalWarehouseId;
    /**
     * 逻辑仓编码
     */
    @ApiModelProperty(name = "logicalWarehouseCode", value = "逻辑仓编码")
    private String logicalWarehouseCode;
    /**
     * 逻辑仓名称
     */
    @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
    private String logicalWarehouseName;
    /**
     * 已出库数量
     */
    @ApiModelProperty(name = "outItemNum", value = "已出库数量")
    private BigDecimal outItemNum;
    /**
     * 拼箱数
     */
    @ApiModelProperty(name = "joinBoxNum", value = "拼箱数")
    private BigDecimal joinBoxNum;
    /**
     * 总箱数
     */
    @ApiModelProperty(name = "boxNum", value = "总箱数")
    private BigDecimal boxNum;

    @ApiModelProperty(name = "differenceNum", value = "差异数")
    private BigDecimal differenceNum;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    @JsonProperty("updatePerson")
    private String updatePerson;

    @ApiModelProperty(name = "updateTime", value = "修改时间")
    @JsonProperty("updateTime")
    private Date updateTime;

    @ApiModelProperty(name = "salePrice", value = "产品销售单价/含税单价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "lineAmount", value = "行金额(含税）/税价合计")
    private BigDecimal lineAmount;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;

    @ApiModelProperty(name = "createPerson", value = "创建人")
    @JsonProperty("createPerson")
    private String createPerson;

    private Long createTimeLong;

    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "giveDate", value = "生产日期")
    private Date giveDate;

    @ApiModelProperty(name = "expireDate", value = "到期日期")
    private Date expireDate;

    @ApiModelProperty(name = "warehouseCode", value = "物理仓仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "remark", value = "订单备注")
    private String remark;

    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;

    /**
     * 计算平台订单商品数量 与 WMS发货数量 的差异
     *
     * @return 差异数（绝对值）
     */
    public BigDecimal vcal() {
        return NumberUtil.sub(itemNum, outItemNum).abs();
    }

    /**
     * 总体积计算
     */
    public BigDecimal volumeSum() {
        return NumberUtil.mul(volume, volumeSum);
    }


    /**
     *  组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     *  运单号
     */
    @ApiModelProperty(name = "invoiceNo", value = "运单号")
    private String invoiceNo;
    /**
     *  平台订单商品行唯一码
     */
    @ApiModelProperty(name = "platformOrderItemNo", value = "平台订单商品行唯一码")
    private String platformOrderItemNo;
    /**
     *  促销活动编码
     */
    @ApiModelProperty(name = "promotionActivityCode", value = "促销活动编码")
    private String promotionActivityCode;
    /**
     *  套餐ID
     */
    @ApiModelProperty(name = "packId", value = "套餐ID")
    private String packId;
    /**
     *  组合商品ID
     */
    @ApiModelProperty(name = "groupItemId", value = "组合商品ID")
    private Long groupItemId;
    /**
     *  组合商品名称
     */
    @ApiModelProperty(name = "groupItemName", value = "组合商品名称")
    private String groupItemName;
    /**
     *  组合商品成交价
     */
    @ApiModelProperty(name = "groupItemPayAmount", value = "组合商品成交价")
    private BigDecimal groupItemPayAmount;
    /**
     *  组合商品优惠金额
     */
    @ApiModelProperty(name = "groupItemDiscountAmount", value = "组合商品优惠金额")
    private BigDecimal groupItemDiscountAmount;
    /**
     *  图片地址URL
     */
    @ApiModelProperty(name = "imgUrl", value = "图片地址URL")
    private String imgUrl;

    /**
     *  单价
     */
    @ApiModelProperty(name = "price", value = "单价")
    private BigDecimal price;

    /**
     *  RDC信息
     */
    @ApiModelProperty(name = "rdc", value = "RDC信息")
    private String rdc;

    /**
     *  是否积分商品:0否，1是
     */
    @ApiModelProperty(name = "integralFlag", value = "是否积分商品:0否，1是")
    private Integer integralFlag;

    @ApiModelProperty(name = "integralFlag", value = "是否积分商品:0否，1是")
    private Integer integral;

    /**
     *  重量（kg）
     */
    @ApiModelProperty(name = "weight", value = "重量（kg）")
    private BigDecimal weight;
    /**
     *  重量单位
     */
    @ApiModelProperty(name = "weightUnit", value = "重量单位")
    private String weightUnit;
    /**
     *  渠道仓编码
     */
    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓编码")
    private String channelWarehouseCode;
    /**
     *  拆单时，来源的订单商品id
     */
    @ApiModelProperty(name = "originalOrderItemId", value = "拆单时，来源的订单商品id")
    private Long originalOrderItemId;

    /**
     *  成交单价：计算公式=成交金额/数量
     */
    @ApiModelProperty(name = "transactionPrice", value = "成交单价：计算公式=成交金额/数量")
    private BigDecimal transactionPrice;

    /**
     *  关联寻源结果明细id
     */
    @ApiModelProperty(name = "linkSourceResultItemId", value = "关联寻源结果明细id")
    private Long linkSourceResultItemId;
    /**
     *  发货商品批次号
     */
    @ApiModelProperty(name = "deliveryItemBatchNo", value = "发货商品批次号")
    private String deliveryItemBatchNo;
    /**
     *  商品类型
     */
    @ApiModelProperty(name = "type", value = "商品类型")
    private String type;
    /**
     *  商品业务类型
     */
    @ApiModelProperty(name = "itemAttr", value = "商品业务类型")
    private String itemAttr;
    /**
     *  运费
     */
    @ApiModelProperty(name = "freightCost", value = "运费")
    private BigDecimal freightCost;
    /**
     *  使用积分
     */
    @ApiModelProperty(name = "useIntegral", value = "使用积分")
    private BigDecimal useIntegral;
    /**
     *  优惠金额
     */
    @ApiModelProperty(name = "discountAmount", value = "优惠金额")
    private BigDecimal discountAmount;
    /**
     *  平台优惠金额:平台承担，由主表的平台优惠金额进行分摊计算（以商品单价*数量-商品优惠金额为基数进行平摊）
     */
    @ApiModelProperty(name = "platformDiscountAmount", value = "平台优惠金额:平台承担，由主表的平台优惠金额进行分摊计算（以商品单价*数量-商品优惠金额为基数进行平摊）")
    private BigDecimal platformDiscountAmount;
    /**
     *  商品优惠金额:商家承担
     */
    @ApiModelProperty(name = "goodsDiscountAmount", value = "商品优惠金额:商家承担")
    private BigDecimal goodsDiscountAmount;
    /**
     *  平摊优惠金额
     */
    @ApiModelProperty(name = "shareDiscountAmount", value = "平摊优惠金额")
    private BigDecimal shareDiscountAmount;
    /**
     *  平台调整金额
     */
    @ApiModelProperty(name = "platformAdjustAmount", value = "平台调整金额")
    private BigDecimal platformAdjustAmount;
    /**
     *  支付金额
     */
    @ApiModelProperty(name = "payAmount", value = "支付金额")
    private BigDecimal payAmount;
    /**
     *  拆分订单-应付金额
     */
    @ApiModelProperty(name = "orderTotalAmount", value = "拆分订单-应付金额")
    private BigDecimal orderTotalAmount;
    /**
     *  平台退款状态
     */
    @ApiModelProperty(name = "platformRefundStatus", value = "平台退款状态")
    private String platformRefundStatus;
    /**
     *  商品行状态
     */
    @ApiModelProperty(name = "status", value = "商品行状态")
    private String status;
    /**
     *  商品行退款状态
     */
    @ApiModelProperty(name = "refundStatus", value = "商品行退款状态")
    private String refundStatus;
    /**
     *  是否原单 0-否 1-是
     */
    @ApiModelProperty(name = "isOrigin", value = "是否原单 0-否 1-是")
    private Integer isOrigin;
    /**
     *  赠品类型：1-中台自动赠品 2-平台赠品 3-中台手工赠品
     */
    @ApiModelProperty(name = "giftType", value = "赠品类型：1-中台自动赠品 2-平台赠品 3-中台手工赠品")
    private Integer giftType;
    /**
     *  核算客户编码
     */
    @ApiModelProperty(name = "hsCustomerCode", value = "核算客户编码")
    private String hsCustomerCode;
    /**
     *  核算客户名称
     */
    @ApiModelProperty(name = "hsCustomerName", value = "核算客户名称")
    private String hsCustomerName;
    /**
     *  发货仓库编码
     */
    @ApiModelProperty(name = "storeCode", value = "发货仓库编码")
    private String storeCode;
    /**
     *  快递公司编码
     */
    @ApiModelProperty(name = "logisticsCompanyCode", value = "快递公司编码")
    private String logisticsCompanyCode;
    /**
     *  快递名称
     */
    @ApiModelProperty(name = "logisticsCompany", value = "快递名称")
    private String logisticsCompany;

    @ApiModelProperty("逻辑删除")
    private Integer dr;
    /**
     * 税码
     */
    @ApiModelProperty(name = "taxCode",value = "税码")
    private String taxCode;

    /**
     * 税率
     */
    @ApiModelProperty(name = "taxRate",value = "税率")
    private BigDecimal taxRate;
    /**
     * 行税额
     */
    @ApiModelProperty(name = "lineTaxAmount",value = "行税额")
    private BigDecimal lineTaxAmount;
    /**
     * 扣率
     */
    @ApiModelProperty(name = "settleRate",value = "扣率")
    private BigDecimal settleRate;
    /**
     * 折扣额
     */
    @ApiModelProperty(name = "settleAmount",value = "折扣额")
    private BigDecimal settleAmount;

    /**
     * 积分值
     */
    @ApiModelProperty(name = "totalScore",value = "积分值")
    private BigDecimal totalScore;


    /**
     *  物理仓编码
     */
    @JsonProperty("physicsWarehouseCode")
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;
    /**
     *  物理仓id
     */
    @JsonProperty("physicsWarehouseId")
    @ApiModelProperty(name = "physicsWarehouseId", value = "物理仓id")
    private Long physicsWarehouseId;
    /**
     *  物理仓名称
     */
    @JsonProperty("physicsWarehouseName")
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    /**
     * csp传下来的rdc物理仓(与rdc字段无关)
     */
    @ApiModelProperty(name = "storagePlace",value = "csp传下来的rdc物理仓(与rdc字段无关)")
    private String storagePlace;

    /**
     * 串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0
     */
    @ApiModelProperty(name = "stringCodeResult",value = "串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0")
    private String stringCodeResult;


    /**
     * 指定供货仓id
     */
    @ApiModelProperty(name = "storagePlaceId",value = "指定供货仓id")
    private Long storagePlaceId;

    /**
     * 指定供货仓
     */
    @ApiModelProperty(name = "storagePlaceName",value = "指定供货仓名称")
    private String storagePlaceName;

    /**
     * eas单号
     */
    @JsonProperty("easOrderNo")
    @ApiModelProperty(name = "easOrderNo",value = "eas单号")
    private String easOrderNo;

    @ApiModelProperty( name = "channelName",value = "订单渠道名称")
    private String channelName;
    /**
     *  订单渠道编码
     */
    @JsonProperty("channelCode")
    @ApiModelProperty(name = "channelCode", value = "订单渠道编码")
    private String channelCode;
    /**
     *  订单渠道id
     */
    @JsonProperty("channelId")
    @ApiModelProperty(name = "channelId", value = "订单渠道id")
    private Long channelId;

    @ApiModelProperty(name="customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;

    /**
     *  详细地址
     */
    @ApiModelProperty(name = "detailAddress", value = "详细地址")
    private String detailAddress;


    @ApiModelProperty(name="deliveryName", value = "收件人姓名")
    @JsonProperty("deliveryName")
    private String deliveryName;


    @ApiModelProperty(name="deliveryPhone", value = "收件人电话")
    @JsonProperty("deliveryPhone")
    private String deliveryPhone;

    @ApiModelProperty(name="platformCreateTime", value = "平台创建时间/下单时间")
    @JsonProperty("platformCreateTime")
    private String platformCreateTime;

    @ApiModelProperty(name="pushOrderTime", value = "PCP推单时间")
    @JsonProperty("pushOrderTime")
    private String pushOrderTime;

    @ApiModelProperty(name="cancelTime", value = "取消时间")
    @JsonProperty("cancelTime")
    private String cancelTime;

    @ApiModelProperty(name="outTime", value = "出库时间")
    @JsonProperty("outTime")
    private String outTime;


    /**
     *省
     */
    @ApiModelProperty(name = "province")
    @JsonProperty("province")
    private String province;
    /**
     *  省份编码
     */
    @ApiModelProperty(name = "provinceCode")
    @JsonProperty("provinceCode")
    private String provinceCode;
    /**
     *  地市编码
     */
    @ApiModelProperty(name = "cityCode")
    @JsonProperty("cityCode")
    private String cityCode;
    /**
     *  地市
     */
    @ApiModelProperty(name = "city")
    @JsonProperty("city")
    private String city;
    /**
     *  区编码
     */
    @ApiModelProperty(name = "countyCode")
    @JsonProperty("countyCode")
    private String countyCode;
    /**
     *  区
     */
    @ApiModelProperty(name = "county")
    @JsonProperty("county")
    private String county;


    @ApiModelProperty(name="deliveryCityCode", value = "城市编码")
    @JsonProperty("deliveryCityCode")
    private String deliveryCityCode;


    @ApiModelProperty(name="deliveryDistrictCode", value = "区县编码")
    @JsonProperty("deliveryDistrictCode")
    private String deliveryDistrictCode;


    @ApiModelProperty(name="deliveryProvinceCode", value = "省份编码")
    @JsonProperty("deliveryProvinceCode")
    private String deliveryProvinceCode;


    @ApiModelProperty(name="deliveryCountryCode", value = "国家编码")
    @JsonProperty("deliveryCountryCode")
    private String deliveryCountryCode;

    @ApiModelProperty(name="deliveryCountry", value = "国家")
    @JsonProperty("deliveryCountry")
    private String deliveryCountry;

    @ApiModelProperty(name="deliveryDetailAddress", value = "详细地址")
    @JsonProperty("deliveryDetailAddress")
    private String deliveryDetailAddress;

    @ApiModelProperty(name="deliveryProvince", value = "省份名称")
    @JsonProperty("deliveryProvince")
    private String deliveryProvince;


    @ApiModelProperty(name="deliveryCity", value = "城市名称")
    @JsonProperty("deliveryCity")
    private String deliveryCity;


    @ApiModelProperty(name="deliveryDistrict", value = "区县名称")
    @JsonProperty("deliveryDistrict")
    private String deliveryDistrict;

    /**
     * eas单号
     */
    @JsonProperty("easOutOrderNo")
    @ApiModelProperty(name = "easOutOrderNo",value = "eas出库单号")
    private String easOutOrderNo;

    /**
     * 实际发货出库批次
     */
    @ApiModelProperty(name = "deliveryOutBatchNo", value = "实际发货出库批次")
    private String deliveryOutBatchNo;

    /**
     *  承运商
     */
    @JsonProperty("deliveryCompany")
    @ApiModelProperty(name = "deliveryCompany", value = "承运商")
    private String deliveryCompany;

    /**
     *  发货方式
     */
    @JsonProperty("deliveryType")
    @ApiModelProperty(name = "deliveryType", value = "发货方式")
    private String deliveryType;


    @ApiModelProperty(name="produtionDate", value = "生产日期YY-MM-DD")
    @JsonProperty("produtionDate")
    private String produtionDate;


    @ApiModelProperty(name="dueDate", value = "到期日期YY-MM-DD")
    @JsonProperty("dueDate")
    private String dueDate;

    @ApiModelProperty(name="shippingNo", value = "快递单号")
    @JsonProperty("shippingNo")
    private String shippingNo;

    @ApiModelProperty(name="logisticsNo", value = "物流单号")
    @JsonProperty("logisticsNo")
    private String logisticsNo;

    @ApiModelProperty(name="outNoticeOrderNo", value = "出库通知单号")
    @JsonProperty("outNoticeOrderNo")
    private String outNoticeOrderNo;

    @ApiModelProperty(name="deliveryTime", value = "发货时间")
    @JsonProperty("deliveryTime")
    private String deliveryTime;

    @ApiModelProperty(name="easVerifyTime", value = "财审时间")
    @JsonProperty("easVerifyTime")
    private String easVerifyTime;

    @ApiModelProperty(name = "allotType", value = "调拨方式")
    private String allotType;

    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
    private String allotOutWarehouseCode;

    @ApiModelProperty(name = "allotOutWarehouseName", value = "调出仓名称")
    private String allotOutWarehouseName;

    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
    private String allotInWarehouseCode;

    @ApiModelProperty(name = "allotInWarehouseName", value = "调入仓名称")
    private String allotInWarehouseName;



}
