package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsNoticeWmsStatusReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsNoticeWmsStatusRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 出库/入库通知单wms状态服务接口
*
* @author 紫霄
* @since 2023-07-24
*/
@Api(tags = {"出库/入库通知单wms状态服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICsNoticeWmsStatusQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/channelLogic",
    url = "${tcbj.center.report.api:}"
)
public interface ICsNoticeWmsStatusQueryApi {

    /**
    * 根据id查询出库/入库通知单wms状态
    *
    * @param id 出库/入库通知单wms状态id
    * @return   出库/入库通知单wms状态数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出库/入库通知单wms状态", notes = "根据id查询出库/入库通知单wms状态")
    RestResponse<CsNoticeWmsStatusRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 出库/入库通知单wms状态分页数据
    *
    * @return 出库/入库通知单wms状态分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "出库/入库通知单wms状态分页数据", notes = "根据filter查询条件查询出库/入库通知单wms状态数据，filter=CsNoticeWmsStatusReqDto")
    RestResponse<PageInfo<CsNoticeWmsStatusRespDto>> queryByPage(@RequestBody CsNoticeWmsStatusReqDto csNoticeWmsStatusReqDto);

}
