package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportPageReqDto;
import com.dtyunxi.tcbj.api.dto.UpdateBillOrgDto;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.simpleframework.xml.core.Validate;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description 基线-报表中心-分拣计费明细报表服务接口
 * @Author 代码生成器
 * @Date 2025-08-26 14:59:24
 * @TemplateVersion 1.0.0
 * @MD5Code 15d3b14a91704f8ca1413cfdbd5e2a72
 **/
@Api(tags = {"基线-报表中心-分拣计费明细报表服务接口"})
@FeignClient(name = "${com.yunxi.dg.base.center.report.api.name:yunxi-dg-base-center-report}", url = "${com.yunxi.dg.base.center.report.api:}")
public interface ISortingExpenseChargingApi {

    @PostMapping(path = "/v1/sortingExpenseCharging/get/{id}")
    @ApiOperation(value = "根据id获取分拣计费明细报表数据", notes = "根据id获取分拣计费明细报表数据")
    RestResponse<SortingExpenseChargingDto> get(@PathVariable(name = "id", required = true) Long id);

    @PostMapping(path = "/v1/sortingExpenseCharging/updateBillOrg")
    @ApiOperation(value = "修改计费组织", notes = "修改计费组织")
    RestResponse<Void> updateBillOrg(@RequestBody @Validate UpdateBillOrgDto reqDto);

    @PostMapping(path = "/v1/sortingExpenseCharging/page")
    @ApiOperation(value = "分页查询分拣计费明细报表数据", notes = "分页查询分拣计费明细报表数据")
    RestResponse<PageInfo<SortingExpenseChargingReportDto>> page(@RequestBody SortingExpenseChargingReportPageReqDto dto);

    @PostMapping(path = "/v1/sortingExpenseCharging/generateBySortingFee")
    @ApiOperation(value = "重新生成", notes = "重新生成")
    RestResponse<Void> generateBySortingFee(@RequestBody FeeGenerateReqDto reqDto);

    @PostMapping(path ="/v1/sortingExpenseCharging/generateInsurance")
    @ApiOperation(value = "根据每日发货报表生成分拣费明细", notes = "根据每日发货报表生成分拣费明细")
    RestResponse<Void> generateInsurance(@RequestBody FeeGenerateReqDto reqDto);

    @PostMapping(path ="/v1/sortingExpenseCharging/querySortingCount")
    @ApiOperation(value = "分拣计费明细报表统计数据", notes = "分拣计费明细报表统计数据")
    RestResponse<ReInsuranceBillCountDto> querySortingCount(@RequestBody SortingExpenseChargingReportPageReqDto reqDto);

    @PostMapping("/v1/sortingExpenseCharging/updatePlaceStatus")
    @ApiOperation(value = "分拣计费明细更新归档标识", notes = "分拣计费明细更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

    @PostMapping(path = "/v1/sortingExpenseCharging/hasPlacedFlag")
    @ApiOperation(value = "查询分拣计费明细是否存在归档数据", notes = "查询分拣计费明细是否存在归档数据")
    RestResponse<Boolean> hasPlacedFlag(@RequestBody SortingExpenseChargingReportPageReqDto dto);


}